/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.store.server.pap.modbus;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.modbus.ModbusClient;
import org.rvpf.service.ServiceActivator;
import org.rvpf.store.server.the.TheStoreServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.modbus.ModbusTests;
import org.rvpf.tests.pap.modbus.ModbusTestsSupport;
import org.rvpf.tests.store.StoreClientTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class UpdatesListenerTests
extends StoreClientTests {
    private static final String _MODBUS_STORE_NAME = "Modbus";
    private static final String _NOTIFIER_QUEUE_PROPERTIES = "tests.store.notifier.queue";
    private static final String _TESTS_PROPERTIES = "rvpf-modbus.properties";
    private MessagingSupport.Receiver _receiver;
    private ServiceActivator _storeService;
    private ModbusTestsSupport _support;

    @BeforeClass
    public void setUp() throws Exception {
        UpdatesListenerTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        UpdatesListenerTests.setProperty((String)"tests.modbus.listen.port", (String)String.valueOf(UpdatesListenerTests.allocateTCPPort()));
        this.setUpAlerter();
        this._support = new ModbusTestsSupport(this.getMetadata());
        this._storeService = this.startService(TheStoreServiceActivator.class, Optional.of(_MODBUS_STORE_NAME));
        this._receiver = this.getMessaging().createClientReceiver(this.getConfig().getPropertiesGroup(_NOTIFIER_QUEUE_PROPERTIES));
        this._receiver.purge();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._receiver.commit();
        this._receiver.purge();
        this._receiver.close();
        this._receiver = null;
        this.stopService(this._storeService);
        this._storeService = null;
        this.tearDownAlerter();
    }

    @Test
    public void test() throws Exception {
        ModbusClient client = this._support.getClient();
        _Tests tests = new _Tests(this._support, this);
        Require.success((boolean)client.connect(this._support.getServerOrigin()));
        tests.test();
        client.disconnect(this._support.getServerOrigin());
    }

    protected int getTimeout() {
        return super.getTimeout();
    }

    @Nonnull
    @CheckReturnValue
    MessagingSupport.Receiver getReceiver() {
        return (MessagingSupport.Receiver)Require.notNull((Object)this._receiver);
    }

    void updateStoreValues(@Nonnull List<PointValue> pointValues) throws Exception {
        Metadata metadata = UpdatesListenerTests.getMetadata((ServiceActivator)this._storeService);
        ListIterator<PointValue> iterator = pointValues.listIterator();
        while (iterator.hasNext()) {
            PointValue pointValue = iterator.next();
            Optional point = metadata.getPointByUUID(pointValue.getPointUUID());
            iterator.set(pointValue.morph(point, Optional.empty()));
        }
        UpdatesListenerTests.updateStoreValues((ServiceActivator)this._storeService, pointValues);
    }

    private static final class _Tests
    extends ModbusTests {
        _Tests(@Nonnull ModbusTestsSupport suppport, @Nonnull UpdatesListenerTests owner) {
            super(suppport, (Tests)owner);
        }

        @Override
        protected Optional<PointValue> getNextPointValue() {
            UpdatesListenerTests owner = (UpdatesListenerTests)this.getOwner();
            try {
                return Optional.ofNullable((PointValue)owner.getReceiver().receive((long)owner.getTimeout()));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        protected void putValue(Point point, DateTime stamp, Serializable value) throws Exception {
            LinkedList<PointValue> pointValues = new LinkedList<PointValue>();
            pointValues.add(new PointValue(point, Optional.of(stamp), null, value));
            ((UpdatesListenerTests)this.getOwner()).updateStoreValues(pointValues);
        }
    }
}

