/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tool;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.tool.ToolsMessages;

public final class ClassConstantsLoader {
    private static final byte _CONSTANT_CLASS = 7;
    private static final byte _CONSTANT_DOUBLE = 6;
    private static final byte _CONSTANT_FIELDREF = 9;
    private static final byte _CONSTANT_FLOAT = 4;
    private static final byte _CONSTANT_INTEGER = 3;
    private static final byte _CONSTANT_INTERFACE_METHODREF = 11;
    private static final byte _CONSTANT_INVOKE_DYNAMIC = 18;
    private static final byte _CONSTANT_LONG = 5;
    private static final byte _CONSTANT_METHODREF = 10;
    private static final byte _CONSTANT_METHOD_HANDLE = 15;
    private static final byte _CONSTANT_METHOD_TYPE = 16;
    private static final byte _CONSTANT_NAME_AND_TYPE = 12;
    private static final byte _CONSTANT_STRING = 8;
    private static final byte _CONSTANT_UTF8 = 1;
    private static final int _MAGIC = -889275714;
    private static final Logger _LOGGER = Logger.getInstance(ClassConstantsLoader.class);
    private final int _classIndex;
    private Map<String, Integer> _classes;
    private final Object[] _constants;
    private final byte[] _tags;

    public ClassConstantsLoader(@Nonnull File classFile) throws IOException {
        this(new FileInputStream(classFile));
    }

    public ClassConstantsLoader(@Nonnull InputStream classInputStream) throws IOException {
        DataInputStream input = new DataInputStream(new BufferedInputStream(classInputStream));
        int magic = input.readInt();
        if (magic != -889275714) {
            input.close();
            throw new ClassFormatError(Message.format((Messages.Entry)ToolsMessages.BAD_MAGIC, (Object[])new Object[]{"0x" + Integer.toHexString(magic).toUpperCase(Locale.ROOT)}));
        }
        input.readShort();
        input.readShort();
        this._constants = new Object[input.readUnsignedShort()];
        this._tags = new byte[this._constants.length];
        block11: for (int i = 1; i < this._constants.length; ++i) {
            this._tags[i] = input.readByte();
            switch (this._tags[i]) {
                case 1: {
                    this._constants[i] = input.readUTF();
                    continue block11;
                }
                case 3: {
                    this._constants[i] = input.readInt();
                    continue block11;
                }
                case 4: {
                    this._constants[i] = new Float(input.readFloat());
                    continue block11;
                }
                case 5: {
                    this._constants[i++] = input.readLong();
                    continue block11;
                }
                case 6: {
                    this._constants[i++] = new Double(input.readDouble());
                    continue block11;
                }
                case 7: 
                case 8: {
                    this._constants[i] = input.readUnsignedShort();
                    continue block11;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this._constants[i] = new int[]{input.readUnsignedShort(), input.readUnsignedShort()};
                    continue block11;
                }
                case 15: {
                    this._constants[i] = new int[]{input.readByte(), input.readUnsignedShort()};
                    continue block11;
                }
                case 16: {
                    this._constants[i] = (int)input.readShort();
                    continue block11;
                }
                default: {
                    throw new ClassFormatError(Message.format((Messages.Entry)ToolsMessages.INVALID_CONSTANT_TYPE, (Object[])new Object[]{this._tags[i]}));
                }
            }
        }
        input.readUnsignedShort();
        this._classIndex = input.readUnsignedShort();
        input.close();
    }

    public static void main(@Nonnull String[] args) {
        ClassConstantsLoader loader;
        if (args.length != 1) {
            _LOGGER.error((Messages.Entry)ToolsMessages.SINGLE_CLASS, new Object[0]);
            System.exit(1);
        }
        String classArg = args[0].trim();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream classInputStream = classLoader.getResourceAsStream(classArg.replace('.', '/') + ".class");
        if (classInputStream == null) {
            _LOGGER.error((Messages.Entry)ToolsMessages.CLASS_NOT_FOUND, new Object[]{classArg});
            System.exit(2);
            return;
        }
        try {
            loader = new ClassConstantsLoader(classInputStream);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        _LOGGER.info((Messages.Entry)ToolsMessages.CLASS, new Object[]{loader.getClassName()});
        for (String className : loader.getClassNames()) {
            _LOGGER.info((Messages.Entry)ToolsMessages.CLASS_REFERENCE, new Object[]{className});
            for (String fieldName : loader.getFieldNames(className)) {
                _LOGGER.info((Messages.Entry)ToolsMessages.CLASS_FIELD, new Object[]{className, fieldName});
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    public String getClassName() {
        return this._className(this._classIndex);
    }

    @Nonnull
    @CheckReturnValue
    public Set<String> getClassNames() {
        if (this._classes == null) {
            this._classes = new HashMap<String, Integer>();
            for (int i = 1; i < this._tags.length; ++i) {
                if (this._tags[i] != 7) continue;
                this._classes.put(this._className(i), i);
            }
        }
        return this._classes.keySet();
    }

    @Nonnull
    @CheckReturnValue
    public List<String> getFieldNames(@Nonnull String className) {
        int classIndex = this._classes.get(className);
        LinkedList<String> fields = new LinkedList<String>();
        for (int i = 1; i < this._tags.length; ++i) {
            int[] fieldRef;
            if (this._tags[i] != 9 || (fieldRef = (int[])this._constants[i])[0] != classIndex) continue;
            int[] nameAndType = (int[])this._constants[fieldRef[1]];
            fields.add((String)this._constants[nameAndType[0]]);
        }
        return fields;
    }

    private String _className(int constantIndex) {
        String className = (String)this._constants[(Integer)this._constants[constantIndex]];
        return className.replace('/', '.');
    }
}

