/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.cip.CIPProxy;
import org.rvpf.pap.cip.CIPSupport;

public abstract class CIPContext
extends PAPContext {
    CIPContext(@Nonnull Optional<Metadata> metadata, @Nonnull Optional<Traces> traces) {
        super(new CIPSupport(), metadata, traces);
    }

    @Override
    public boolean addRemoteOrigin(Origin remoteOrigin, Attributes originAttributes) {
        CIPProxy remoteProxy = this.newRemoteProxy(remoteOrigin);
        if (!remoteProxy.setUp(originAttributes)) {
            return false;
        }
        this.registerRemoteProxy(remoteProxy);
        return true;
    }

    @Override
    public boolean addRemotePoint(Point remotePoint, Attributes pointAttributes) {
        CIPProxy remoteProxy = this.getRemoteProxy(remotePoint).orElse(null);
        if (remoteProxy == null) {
            return false;
        }
        this.registerRemotePoint(remotePoint);
        return true;
    }

    @Nonnull
    @CheckReturnValue
    public String getTag(@Nonnull Point point) {
        String tag;
        Optional pointAttributes = point.getAttributes("CIP");
        String string = tag = pointAttributes.isPresent() ? (String)((Attributes)pointAttributes.get()).getString("TAG").orElse(null) : null;
        if (tag == null) {
            tag = (String)point.getParams().getString("Tag", point.getName()).get();
        }
        return tag;
    }

    @Override
    protected abstract CIPProxy newRemoteProxy(Origin var1);
}

