/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip;

import java.net.InetSocketAddress;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Origin;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.cip.CIPContext;
import org.rvpf.pap.cip.CIPMessages;

public abstract class CIPProxy
extends PAPProxy {
    private String _tcpAddress;
    private int _tcpPort;

    protected CIPProxy(@Nonnull CIPProxy other) {
        super(other);
        this._tcpAddress = other._tcpAddress;
        this._tcpPort = other._tcpPort;
    }

    CIPProxy(@Nonnull CIPContext context, @Nonnull Origin origin) {
        super(context, origin);
    }

    @Override
    public CIPContext getContext() {
        return (CIPContext)super.getContext();
    }

    @Nonnull
    @CheckReturnValue
    public String getTcpAddress() {
        return (String)Require.notNull((Object)this._tcpAddress);
    }

    @CheckReturnValue
    public int getTcpPort() {
        return this._tcpPort;
    }

    @CheckReturnValue
    protected boolean setUp(@Nonnull Attributes originAttributes) {
        String tcpAddressString = (String)originAttributes.getString("TCP_ADDRESS").get();
        Optional tcpSocketAddress = Inet.socketAddress((String)tcpAddressString);
        if (!tcpSocketAddress.isPresent()) {
            this.getThisLogger().warn((Messages.Entry)BaseMessages.BAD_ADDRESS, new Object[]{tcpAddressString});
            return false;
        }
        this._tcpAddress = ((InetSocketAddress)tcpSocketAddress.get()).getHostString();
        this.getThisLogger().debug((Messages.Entry)CIPMessages.TCP_ADDRESS, new Object[]{this._tcpAddress});
        this._tcpPort = ((InetSocketAddress)tcpSocketAddress.get()).getPort();
        if (this._tcpPort <= 0) {
            this._tcpPort = originAttributes.getInt("TCP_PORT", 44818);
        }
        this.getThisLogger().debug((Messages.Entry)CIPMessages.TCP_PORT, new Object[]{String.valueOf(this._tcpPort)});
        return true;
    }
}

