/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip.transport;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.PAPTransaction;
import org.rvpf.pap.cip.CIPServerProxy;

abstract class Transaction
implements PAPTransaction {
    private Exception _exception;
    private final CIPServerProxy _serverProxy;

    protected Transaction(@Nonnull CIPServerProxy serverProxy) {
        this._serverProxy = serverProxy;
    }

    @Nonnull
    @CheckReturnValue
    Optional<Exception> getException() {
        return Optional.ofNullable(this._exception);
    }

    @Nonnull
    @CheckReturnValue
    CIPServerProxy getServerProxy() {
        return this._serverProxy;
    }

    void setException(@Nonnull Exception exception) {
        this._exception = (Exception)Require.notNull((Object)exception);
    }

    public static abstract class Response
    implements PAPTransaction.Response {
        private final Request _request;

        protected Response(@Nonnull Request request) {
            this._request = (Request)Require.notNull((Object)request);
        }

        @Nonnull
        @CheckReturnValue
        public Request getRequest() {
            return this._request;
        }
    }

    public abstract class Request
    implements PAPTransaction.Request {
        protected Request() {
        }
    }
}

