/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap.cip;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.content.TupleContent;
import org.rvpf.pap.PAPMessages;
import org.rvpf.processor.engine.pap.PAPSplitter;

public final class CIPSplitter
extends PAPSplitter {
    private final Map<Point, _Plan> _plans = new IdentityHashMap<Point, _Plan>();

    @Override
    public boolean setUp(Point point) {
        if (this._plans.containsKey(point)) {
            return true;
        }
        Optional origin = point.getOrigin();
        if (origin.isPresent()) {
            Optional attributes = ((Origin)origin.get()).getAttributes("CIP");
            if (!attributes.isPresent()) {
                this.getThisLogger().debug((Messages.Entry)PAPMessages.MISSING_ATTRIBUTES, new Object[]{"CIP", origin.get()});
            }
        } else {
            this.getThisLogger().debug((Messages.Entry)PAPMessages.MISSING_ORIGIN, new Object[]{point});
        }
        boolean multipleValues = point.getContent().orElse(null) instanceof TupleContent;
        List resultRelations = point.getResults();
        _Detail[] details = new _Detail[resultRelations.size()];
        int detail = 0;
        boolean success = true;
        for (PointRelation resultRelation : resultRelations) {
            int index;
            int n = index = multipleValues ? this.getResultPosition(resultRelation) : 0;
            if (index >= 0) {
                int bit = resultRelation.getParams().getInt("Bit", -1);
                if (bit < 64) {
                    details[detail++] = new _Detail(resultRelation.getResultPoint(), index, bit);
                    continue;
                }
                this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_PARAMETER_VALUE, new Object[]{"Bit", String.valueOf(bit)});
                success = false;
                continue;
            }
            success = false;
        }
        if (details.length > 0) {
            this._plans.put(point, new _Plan(details));
        }
        return success;
    }

    @Override
    public Optional<PAPSplitter.Splitted> split(PointValue pointValue) {
        Tuple tuple;
        Serializable value = pointValue.getValue();
        if (value instanceof PAPSplitter.Splitted) {
            return Optional.of((PAPSplitter.Splitted)value);
        }
        if (value instanceof Tuple) {
            tuple = (Tuple)value;
        } else {
            tuple = new Tuple(1);
            tuple.add(value);
        }
        _Plan plan = this._plans.get(pointValue.getPoint().get());
        if (plan == null) {
            return Optional.empty();
        }
        PAPSplitter.Splitted splitted = new PAPSplitter.Splitted();
        for (_Detail detail : plan.getDetails()) {
            splitted.put(detail.getPoint(), CIPSplitter._getValue(plan, tuple, detail));
        }
        return Optional.of(splitted);
    }

    private static Optional<Serializable> _getValue(_Plan plan, Tuple tuple, _Detail detail) {
        Serializable value;
        int index = detail.getPosition();
        if (index >= tuple.size()) {
            return Optional.empty();
        }
        Serializable serializable = tuple.get(index);
        if (serializable instanceof Number) {
            int bit = detail.getBit();
            if (bit >= 0) {
                int size;
                if (serializable instanceof Integer) {
                    size = 32;
                } else if (serializable instanceof Short) {
                    size = 16;
                } else if (serializable instanceof Byte) {
                    size = 8;
                } else if (serializable instanceof Long) {
                    size = 64;
                } else {
                    return Optional.empty();
                }
                if (bit >= size) {
                    index += bit / size;
                    bit %= size;
                    if (index >= tuple.size()) {
                        return Optional.empty();
                    }
                    serializable = tuple.get(index);
                }
                value = Boolean.valueOf((((Number)serializable).longValue() & (long)(1 << bit)) != 0L);
            } else {
                value = serializable;
            }
        } else {
            value = serializable;
        }
        return Optional.ofNullable(value);
    }

    private static final class _Plan
    extends PAPSplitter.Plan {
        _Plan(@Nonnull _Detail[] details) {
            super(details);
        }

        protected _Detail[] getDetails() {
            return (_Detail[])super.getDetails();
        }
    }

    private static final class _Detail
    extends PAPSplitter.Detail {
        _Detail(@Nonnull Point point, int position, int bit) {
            super(point, position, bit);
        }
    }
}

