/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.PathInputPanel;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class AnchoredTargetPanel
extends PathInputPanel {
    private static final long serialVersionUID = 1L;
    private static final String _CORE_DIR_NAME = "core";
    private static final String _CORE_PRESENT_VAR = "core_present";
    private static final String _CORE_REQUIRED_VAR = "core_required";
    private static final String _HOME_KEY = "home";
    private static final String _HOME_NODE_PATH_VAR = "home_node_path";
    private static final String _PROJECT_SUBDIR_VAR = "project_subdir";
    private static final String _ROOT_NAME_VAR = "root_name";
    private static final String _ROOT_PATH_VAR = "root_path";
    private static final String _RVPF_NODE_PATH = "/org/rvpf";

    public AnchoredTargetPanel(InstallerFrame frame, InstallData data) {
        super(frame, data);
        this._setDefaultInstallDir();
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        this.pathSelectionPanel.setPath(this.idata.getInstallPath());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isValidated() {
        if (!super.isValidated()) {
            return false;
        }
        String path = this.pathSelectionPanel.getPath();
        File installDir = new File(path);
        String rootName = this.idata.getVariable(_ROOT_NAME_VAR);
        String subdirName = this.idata.getVariable(_PROJECT_SUBDIR_VAR);
        if (subdirName != null) {
            if (!subdirName.equals(installDir.getName())) {
                this.emitError("Installer error", "The target directory must be named '" + subdirName + "'!");
                return false;
            }
            File rootDir = installDir.getParentFile();
            if (rootDir == null || !rootName.equals(rootDir.getName())) {
                this.emitError("Installer error", "The parent directory must be named '" + rootName + "'!");
                return false;
            }
            this.idata.setVariable(_ROOT_PATH_VAR, rootDir.getAbsolutePath());
            boolean corePresent = new File(rootDir, _CORE_DIR_NAME).isDirectory();
            this.idata.setVariable(_CORE_PRESENT_VAR, Boolean.toString(corePresent));
            if (!corePresent && Boolean.TRUE.toString().equalsIgnoreCase(this.idata.getVariable(_CORE_REQUIRED_VAR))) {
                this.emitError("Installer error", "The 'core' install is required!");
                return false;
            }
        } else if (!rootName.equals(installDir.getName())) {
            this.emitError("Installer error", "The target directory must be named '" + rootName + "'!");
            return false;
        }
        this.idata.setInstallPath(path);
        return true;
    }

    private void _setDefaultInstallDir() {
        String nodePath = this.idata.getVariable(_HOME_NODE_PATH_VAR);
        File home = null;
        if (nodePath != null && (home = AnchoredTargetPanel._getDefaultInstallDir(nodePath)) == null) {
            home = AnchoredTargetPanel._getDefaultInstallDir(_RVPF_NODE_PATH);
            if (home != null) {
                home = home.getParentFile();
            }
            if (home != null) {
                home = new File(home, this.idata.getVariable(_ROOT_NAME_VAR));
            }
        }
        if (home == null) {
            for (home = new File(System.getProperty("user.home")); home != null && home.getAbsolutePath().contains(" "); home = home.getParentFile()) {
            }
            if (home != null && !home.canWrite()) {
                home = null;
            }
            if (home != null) {
                home = new File(home, this.idata.getVariable(_ROOT_NAME_VAR));
            } else {
                AnchoredTargetPanel.loadDefaultInstallDir(this.parent, this.idata);
                if (AnchoredTargetPanel.getDefaultInstallDir() != null) {
                    home = new File(AnchoredTargetPanel.getDefaultInstallDir());
                }
            }
        }
        if (home != null) {
            String subdirName = this.idata.getVariable(_PROJECT_SUBDIR_VAR);
            if (subdirName != null) {
                home = new File(home, subdirName);
            }
            AnchoredTargetPanel.setDefaultInstallDir(home.getAbsolutePath());
        }
        this.idata.setInstallPath(AnchoredTargetPanel.getDefaultInstallDir());
    }

    private static File _getDefaultInstallDir(String nodePath) {
        Preferences userRoot = Preferences.userRoot();
        String home = null;
        try {
            if (userRoot.nodeExists(nodePath)) {
                home = userRoot.node(nodePath).get(_HOME_KEY, null);
            }
        }
        catch (BackingStoreException exception) {
            throw new RuntimeException(exception);
        }
        return home != null ? new File(home) : null;
    }
}

