/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Entity;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.tests.Tests;
import org.testng.annotations.Test;

public abstract class PAPContextTests
extends Tests {
    private final String _attributesUsage;
    private int _originIndex;
    private int _pointIndex;

    protected PAPContextTests(@Nonnull String usage) {
        this._attributesUsage = usage;
    }

    @Test(priority=120)
    public void shouldRequireKnownOriginForPoint() {
        Point point = this.newPoint(Optional.of(this.newOriginEntity()));
        this.expectLogs(new Messages.Entry[]{PAPMessages.UNKNOWN_ORIGIN});
        boolean pointAccepted = this.getServerContext().addRemotePoint(point, (Attributes)this.getAttributes((Entity)point).orElse(null));
        Require.failure((boolean)pointAccepted, (Object)"point accepted");
        this.requireLogs(new Messages.Entry[]{PAPMessages.UNKNOWN_ORIGIN});
    }

    @Test(priority=110)
    public void shouldRequireOriginForPoint() {
        Point point = this.newPoint(Optional.empty());
        this.expectLogs(new Messages.Entry[]{PAPMessages.MISSING_ORIGIN});
        boolean pointAccepted = this.getServerContext().addRemotePoint(point, (Attributes)this.getAttributes((Entity)point).orElse(null));
        Require.failure((boolean)pointAccepted, (Object)"point accepted");
        this.requireLogs(new Messages.Entry[]{PAPMessages.MISSING_ORIGIN});
    }

    @Nonnull
    @CheckReturnValue
    protected Optional<Attributes> getAttributes(Entity entity) {
        return entity.getAttributes(this._attributesUsage);
    }

    @Nonnull
    @CheckReturnValue
    protected abstract PAPContext getServerContext();

    @Nonnull
    @CheckReturnValue
    protected OriginEntity newOriginEntity() {
        OriginEntity.Builder originBuilder = OriginEntity.newBuilder();
        KeyedGroups attributes = new KeyedGroups();
        attributes.setValue(this._attributesUsage, (Object)new Attributes(this._attributesUsage));
        originBuilder.setName("CONTEXT_TESTS_" + ++this._originIndex);
        originBuilder.setAttributes(Optional.of(attributes));
        return originBuilder.build();
    }

    @Nonnull
    @CheckReturnValue
    protected Point newPoint(@Nonnull Optional<OriginEntity> origin) {
        PointEntity.Definition point = new PointEntity.Definition();
        KeyedGroups attributes = new KeyedGroups();
        point.setName(Optional.of("CONTEXT_TESTS_" + ++this._pointIndex));
        point.setOriginEntity(origin);
        attributes.setValue(this._attributesUsage, (Object)new Attributes(this._attributesUsage));
        point.setAttributes(Optional.of(attributes));
        return point;
    }
}

