/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.object.ObjectHeader;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectRange;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputVariation;
import org.rvpf.pap.dnp3.transport.ApplicationLayer;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.FunctionCode;
import org.rvpf.service.ServiceThread;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.dnp3.DNP3TestsMessages;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.testng.annotations.Test;

public final class DNP3ApplicationLayerTests
extends Tests
implements ServiceThread.Target {
    private ApplicationLayer _outstationApplicationLayer;
    private ServerSocketChannel _outstationSocketChannel;
    private final InetSocketAddress _tcpSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), DNP3ApplicationLayerTests.allocateTCPPort());

    public DNP3ApplicationLayerTests() throws Exception {
        this._outstationSocketChannel = ServerSocketChannel.open();
        this._outstationSocketChannel.bind(this._tcpSocketAddress);
    }

    public void run() throws Exception {
        Fragment receivedFragment = this._outstationApplicationLayer.receive();
        Fragment.Header receivedFragmentHeader = receivedFragment.getHeader();
        Require.equal((Object)receivedFragmentHeader.getFunctionCode(), (Object)FunctionCode.READ);
        Require.success((boolean)receivedFragmentHeader.isInRequest());
        Require.success((boolean)receivedFragmentHeader.isFirst());
        Require.success((boolean)receivedFragmentHeader.isLast());
        Require.failure((boolean)receivedFragmentHeader.isConfirmRequested());
        Require.failure((boolean)receivedFragmentHeader.isUnsolicited());
        LinkedList receivedItems = receivedFragment.getItems();
        Require.equal((long)1L, (long)receivedItems.size());
        ObjectHeader receivedObjectHeader = ((Fragment.Item)receivedItems.get(0)).getObjectHeader();
        Require.notNull((Object)receivedObjectHeader);
        Require.equal((Object)receivedObjectHeader.getPrefixCode(), (Object)ObjectHeader.PrefixCode.NONE);
        Require.equal((Object)receivedObjectHeader.getRangeCode(), (Object)ObjectHeader.RangeCode.START_STOP_INDEX_BYTE);
        Require.success((boolean)Arrays.equals((byte[])receivedObjectHeader.getRange().get(), new byte[]{3, 3}));
        ObjectVariation receivedVariation = receivedObjectHeader.getObjectVariation();
        Require.equal((Object)receivedVariation, (Object)AnalogInputVariation.SHORT_WITHOUT_FLAG);
        Optional receivedInstances = ((Fragment.Item)receivedItems.get(0)).getObjectInstances();
        Require.failure((boolean)receivedInstances.isPresent());
        Fragment.Header fragmentHeader = Fragment.Header.newInstance(Optional.of(FunctionCode.RESPONSE), (boolean)false);
        Fragment sentFragment = new Fragment(receivedFragment.getAssociation(), fragmentHeader);
        ObjectHeader sentObjectHeader = ObjectHeader.newInstance((ObjectHeader)receivedObjectHeader);
        ObjectInstance.WithValue sentObject = (ObjectInstance.WithValue)receivedObjectHeader.getObjectVariation().newObjectInstance();
        sentObject.setValue((Serializable)Integer.valueOf(1234));
        fragmentHeader.setFirst();
        Require.success((boolean)sentFragment.add(new Fragment.Item(sentObjectHeader, Optional.of(new ObjectInstance[]{sentObject}))));
        fragmentHeader.setLast();
        sentFragment.send();
    }

    @Test
    public void test() throws Exception {
        DNP3TestsSupport support = new DNP3TestsSupport(Optional.empty());
        Connection masterConnection = support.newTCPConnection(true, SocketChannel.open(this._tcpSocketAddress));
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.MASTER_CONNECTION, new Object[]{masterConnection});
        Connection outstationConnection = support.newTCPConnection(false, this._outstationSocketChannel.accept());
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.OUTSTATION_CONNECTION, new Object[]{outstationConnection});
        outstationConnection.activate();
        masterConnection.activate();
        Association outstationMasterAssociation = outstationConnection.getRemoteEndPoint().getAssociation((short)0, (short)0);
        this._outstationApplicationLayer = outstationMasterAssociation.getApplicationLayer();
        Association masterOutstationAssociation = masterConnection.getRemoteEndPoint().getAssociation((short)0, (short)0);
        ApplicationLayer masterApplicationLayer = masterOutstationAssociation.getApplicationLayer();
        ServiceThread serviceThread = new ServiceThread((ServiceThread.Target)this, "Transport tests");
        serviceThread.start();
        Fragment.Header sentFragmentHeader = Fragment.Header.newInstance(Optional.of(FunctionCode.READ), (boolean)true);
        Fragment sentFragment = new Fragment(masterOutstationAssociation, sentFragmentHeader);
        ObjectHeader sentObjectHeader = ObjectHeader.newInstance((ObjectVariation)AnalogInputVariation.SHORT_WITHOUT_FLAG, (ObjectRange)ObjectRange.newIndexInstance((int)3, (int)3));
        sentFragmentHeader.setFirst();
        Require.success((boolean)sentFragment.add(new Fragment.Item(sentObjectHeader)));
        sentFragmentHeader.setLast();
        sentFragment.send();
        Fragment receivedFragment = masterApplicationLayer.receive();
        Fragment.Header receivedFragmentHeader = receivedFragment.getHeader();
        Require.equal((Object)receivedFragmentHeader.getFunctionCode(), (Object)FunctionCode.RESPONSE);
        Require.failure((boolean)receivedFragmentHeader.isInRequest());
        Require.success((boolean)receivedFragmentHeader.isFirst());
        Require.success((boolean)receivedFragmentHeader.isLast());
        Require.failure((boolean)receivedFragmentHeader.isConfirmRequested());
        Require.failure((boolean)receivedFragmentHeader.isUnsolicited());
        LinkedList receivedItems = receivedFragment.getItems();
        ObjectHeader receivedObjectHeader = ((Fragment.Item)receivedItems.get(0)).getObjectHeader();
        Require.equal((Object)receivedObjectHeader.getPrefixCode(), (Object)ObjectHeader.PrefixCode.NONE);
        Require.equal((Object)receivedObjectHeader.getRangeCode(), (Object)ObjectHeader.RangeCode.START_STOP_INDEX_BYTE);
        Require.success((boolean)Arrays.equals((byte[])receivedObjectHeader.getRange().get(), new byte[]{3, 3}));
        ObjectVariation receivedVariation = receivedObjectHeader.getObjectVariation();
        Require.equal((Object)receivedVariation, (Object)AnalogInputVariation.SHORT_WITHOUT_FLAG);
        ObjectInstance[] receivedInstances = (ObjectInstance[])((Fragment.Item)receivedItems.get(0)).getObjectInstances().get();
        Require.equal((long)1L, (long)receivedInstances.length);
        ObjectInstance.WithValue receivedInstance = (ObjectInstance.WithValue)receivedInstances[0];
        Require.equal((Object)receivedInstance.getObjectVariation(), (Object)AnalogInputVariation.SHORT_WITHOUT_FLAG);
        Require.equal((long)3L, (long)receivedInstance.getObjectIndex());
        Require.equal((Object)receivedInstance.getValue(), (Object)1234);
        Require.ignored((boolean)serviceThread.join(this.getThisLogger(), (long)this.getTimeout(DEFAULT_TIMEOUT)));
        masterConnection.close();
        outstationConnection.close();
    }
}

