/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.TransportFunction;
import org.rvpf.service.ServiceThread;
import org.rvpf.tests.pap.dnp3.DNP3TestsMessages;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class DNP3TransportFunctionTests
extends MetadataServiceTests
implements ServiceThread.Target {
    public static final int DEFAULT_MESSAGE_COUNT = 100;
    public static final String MESSAGE_COUNT_PROPERTY = "tests.transport.messages";
    private static final String _TESTS_PROPERTIES = "rvpf-dnp3.properties";
    private int _messageCount;
    private ServerSocketChannel _outstationSocketChannel;
    private TransportFunction _outstationTransportFunction;
    private final InetSocketAddress _tcpSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), DNP3TransportFunctionTests.allocateTCPPort());

    public DNP3TransportFunctionTests() throws Exception {
        this._outstationSocketChannel = ServerSocketChannel.open();
        this._outstationSocketChannel.bind(this._tcpSocketAddress);
    }

    public void run() {
        ByteBuffer buffer = ByteBuffer.allocate(250);
        try {
            while (true) {
                byte[] message = DNP3TransportFunctionTests._readMessage(this._outstationTransportFunction, buffer);
                buffer.clear();
                buffer.putShort((short)message.length);
                buffer.put(message);
                buffer.flip();
                this._outstationTransportFunction.send(buffer);
            }
        }
        catch (ClosedChannelException exception) {
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @BeforeClass
    public void setUp() {
        DNP3TransportFunctionTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        this._messageCount = this.getConfig().getIntValue(MESSAGE_COUNT_PROPERTY, 100);
    }

    @Test
    public void test() throws Exception {
        DNP3TestsSupport support = new DNP3TestsSupport(Optional.of(this.getMetadata()));
        Connection masterConnection = support.newTCPConnection(true, SocketChannel.open(this._tcpSocketAddress));
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.MASTER_CONNECTION, new Object[]{masterConnection});
        Connection outstationConnection = support.newTCPConnection(false, this._outstationSocketChannel.accept());
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.OUTSTATION_CONNECTION, new Object[]{outstationConnection});
        outstationConnection.activate();
        masterConnection.activate();
        Association outstationMasterAssociation = outstationConnection.getRemoteEndPoint().getAssociation((short)0, (short)0);
        this._outstationTransportFunction = outstationMasterAssociation.getTransportFunction();
        Association masterOutstationAssociation = masterConnection.getRemoteEndPoint().getAssociation((short)0, (short)0);
        TransportFunction masterTransportFunction = masterOutstationAssociation.getTransportFunction();
        ServiceThread serviceThread = new ServiceThread((ServiceThread.Target)this, "Transport tests");
        serviceThread.start();
        ByteBuffer buffer = ByteBuffer.allocate(250);
        Random random = new Random();
        for (int i = 1; i <= this._messageCount; ++i) {
            int segmentSize = 2 + random.nextInt(248);
            byte[] sentMessage = new byte[segmentSize - 2];
            random.nextBytes(sentMessage);
            buffer.clear();
            buffer.putShort((short)sentMessage.length);
            buffer.put(sentMessage);
            buffer.flip();
            masterTransportFunction.send(buffer);
            byte[] receivedMessage = DNP3TransportFunctionTests._readMessage(masterTransportFunction, buffer);
            Require.equal((long)sentMessage.length, (long)receivedMessage.length);
            Require.success((boolean)Arrays.equals(receivedMessage, sentMessage));
        }
        masterConnection.close();
        outstationConnection.close();
        Require.ignored((boolean)serviceThread.interruptAndJoin(this.getThisLogger(), (long)this.getTimeout(DEFAULT_TIMEOUT)));
    }

    private static byte[] _readMessage(TransportFunction transportFunction, ByteBuffer buffer) throws Exception {
        buffer.clear();
        do {
            transportFunction.receive(buffer);
        } while (buffer.position() < 2);
        buffer.flip();
        int messageSize = buffer.getShort();
        int fragmentSize = 2 + messageSize;
        Require.success((fragmentSize >= 1 ? 1 : 0) != 0);
        Require.success((fragmentSize <= 250 ? 1 : 0) != 0);
        byte[] message = new byte[messageSize];
        for (int i = 0; i < messageSize; ++i) {
            if (!buffer.hasRemaining()) {
                buffer.clear();
                transportFunction.receive(buffer);
                buffer.flip();
            }
            message[i] = buffer.get();
        }
        return message;
    }
}

