/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.modbus;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.modbus.ModbusClient;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusServer;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.modbus.ModbusTests;
import org.rvpf.tests.pap.modbus.ModbusTestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class ModbusClientServerTests
extends MetadataServiceTests
implements PAPProxy.Responder,
PAPConnectionListener {
    private static final String _TESTS_PROPERTIES = "rvpf-modbus.properties";
    private boolean _connected;
    private final CountDownLatch _disconnected = new CountDownLatch(1);
    private final Map<UUID, PointValue> _pointValues = new ConcurrentHashMap<UUID, PointValue>();
    private ModbusTestsSupport _support;

    public boolean onLostConnection(PAPProxy remoteProxy, Optional<Exception> cause) {
        Require.success((this._disconnected.getCount() > 0L ? 1 : 0) != 0);
        this._disconnected.countDown();
        return true;
    }

    public boolean onNewConnection(PAPProxy remoteProxy) {
        Require.failure((boolean)this._connected);
        this._connected = true;
        return true;
    }

    public PointValue[] select(Point[] points) {
        PointValue[] pointValues = new PointValue[points.length];
        for (int i = 0; i < pointValues.length; ++i) {
            pointValues[i] = this._pointValues.get(points[i].getUUID().get());
        }
        return pointValues;
    }

    @BeforeClass
    public void setUp() {
        ModbusClientServerTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        ModbusClientServerTests.setProperty((String)"tests.modbus.listen.port", (String)String.valueOf(ModbusClientServerTests.allocateTCPPort()));
        this._support = new ModbusTestsSupport(this.getMetadata(true));
    }

    @Test
    public void test() throws Exception {
        ModbusServer server = this._support.getServer();
        ModbusClient client = this._support.getClient();
        server.setResponder((PAPProxy.Responder)this);
        server.start();
        client.open();
        Require.success((boolean)client.addConnectionListener((PAPConnectionListener)this));
        this.expectLogs(new Messages.Entry[]{ModbusMessages.CLIENT_CONNECTION_ACCEPTED});
        Require.failure((boolean)this._connected);
        Require.success((boolean)client.connect(this._support.getServerOrigin()));
        Require.success((boolean)this._connected);
        this.waitForLogs(new Messages.Entry[]{ModbusMessages.CLIENT_CONNECTION_ACCEPTED});
        new _Tests(this._support, this).test();
        Require.success((this._disconnected.getCount() > 0L ? 1 : 0) != 0);
        server.stop();
        Require.success((boolean)this._disconnected.await(this.getTimeout(), TimeUnit.MILLISECONDS));
        client.disconnect();
        Require.success((boolean)client.removeConnectionListener((PAPConnectionListener)this));
        client.close();
    }

    void _putValue(@Nonnull PointValue pointValue) {
        this._pointValues.put(pointValue.getPointUUID(), pointValue);
    }

    private static final class _Tests
    extends ModbusTests {
        _Tests(@Nonnull ModbusTestsSupport suppport, @Nonnull ModbusClientServerTests owner) {
            super(suppport, (Tests)owner);
        }

        @Override
        protected Optional<PointValue> getNextPointValue() {
            ModbusServer server = this.getSupport().getServer();
            try {
                return server.nextUpdate((long)this.getTimeout());
            }
            catch (InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        protected void putValue(Point point, DateTime stamp, Serializable value) {
            ((ModbusClientServerTests)this.getOwner())._putValue(new PointValue(point, Optional.of(stamp), null, value));
        }
    }
}

