/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.modbus;

import java.util.Optional;
import org.rvpf.base.Attributes;
import org.rvpf.base.Entity;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.config.Config;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusServerContext;
import org.rvpf.pap.modbus.ModbusSupport;
import org.rvpf.tests.pap.PAPContextTests;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public final class ModbusContextTests
extends PAPContextTests {
    private ModbusServerContext _serverContext;

    public ModbusContextTests() {
        super("MODBUS");
    }

    @BeforeMethod
    public void setUpServerContext() {
        ModbusSupport support = new ModbusSupport();
        this._serverContext = support.newServerContext(new Metadata(new Config("")), new String[0], Optional.empty());
        Require.notNull((Object)this._serverContext);
    }

    @Test(priority=40)
    public void shouldAcceptMultipleAddresses() {
        OriginEntity originEntity = this.newOriginEntity();
        Attributes originAttributes = this.getAttributes((Entity)originEntity).get();
        originAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        originAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.2");
        boolean originAccepted = this.getServerContext().addRemoteOrigin((Origin)originEntity, originAttributes);
        Require.success((boolean)originAccepted, (Object)"origin accepted");
    }

    @Test(priority=40)
    public void shouldAcceptOriginsWithDifferentAddresses() {
        OriginEntity firstOriginEntity = this.newOriginEntity();
        Attributes firstOriginAttributes = this.getAttributes((Entity)firstOriginEntity).get();
        firstOriginAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        OriginEntity secondOriginEntity = this.newOriginEntity();
        Attributes secondOriginAttributes = this.getAttributes((Entity)secondOriginEntity).get();
        secondOriginAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.2");
        boolean firstOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)firstOriginEntity, firstOriginAttributes);
        boolean secondOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)secondOriginEntity, secondOriginAttributes);
        Require.success((boolean)firstOriginAccepted, (Object)"first origin accepted");
        Require.success((boolean)secondOriginAccepted, (Object)"second origin accepted");
    }

    @Test(priority=20)
    public void shouldAcceptWildNodeAddress() {
        OriginEntity originEntity = this.newOriginEntity();
        Attributes originAttributes = this.getAttributes((Entity)originEntity).get();
        originAttributes.add("SOCKET_ADDRESS", (Object)"*");
        boolean originAccepted = this.getServerContext().addRemoteOrigin((Origin)originEntity, originAttributes);
        Require.success((boolean)originAccepted, (Object)"origin accepted");
    }

    @Test(priority=30)
    public void shouldRejectNodeAddressAfterWild() {
        OriginEntity originEntity = this.newOriginEntity();
        Attributes originAttributes = this.getAttributes((Entity)originEntity).get();
        originAttributes.add("SOCKET_ADDRESS", (Object)"*");
        originAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        this.expectLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
        boolean originAccepted = this.getServerContext().addRemoteOrigin((Origin)originEntity, originAttributes);
        Require.failure((boolean)originAccepted, (Object)"origin accepted");
        this.requireLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
    }

    @Test(priority=30)
    public void shouldRejectOriginsWithSameAddress() {
        OriginEntity firstOriginEntity = this.newOriginEntity();
        Attributes firstOriginAttributes = this.getAttributes((Entity)firstOriginEntity).get();
        firstOriginAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        OriginEntity otherOriginEntity = this.newOriginEntity();
        Attributes otherOriginAttributes = this.getAttributes((Entity)otherOriginEntity).get();
        otherOriginAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        boolean firstOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)firstOriginEntity, firstOriginAttributes);
        this.expectLogs(new Messages.Entry[]{PAPMessages.AMBIGUOUS_ORIGIN_ADDRESS});
        boolean otherOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)otherOriginEntity, otherOriginAttributes);
        Require.success((boolean)firstOriginAccepted, (Object)"first origin accepted");
        this.requireLogs(new Messages.Entry[]{PAPMessages.AMBIGUOUS_ORIGIN_ADDRESS});
        Require.failure((boolean)otherOriginAccepted, (Object)"other origin accepted");
    }

    @Test(priority=30)
    public void shouldRejectOtherAfterWildOrigin() {
        OriginEntity firstOriginEntity = this.newOriginEntity();
        Attributes firstOriginAttributes = this.getAttributes((Entity)firstOriginEntity).get();
        firstOriginAttributes.add("SOCKET_ADDRESS", (Object)"*");
        OriginEntity otherOriginEntity = this.newOriginEntity();
        Attributes otherOriginAttributes = this.getAttributes((Entity)otherOriginEntity).get();
        boolean firstOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)firstOriginEntity, firstOriginAttributes);
        this.expectLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
        boolean otherOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)otherOriginEntity, otherOriginAttributes);
        Require.success((boolean)firstOriginAccepted, (Object)"first origin accepted");
        Require.failure((boolean)otherOriginAccepted, (Object)"other origin accepted");
        this.requireLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
    }

    @Test(priority=30)
    public void shouldRejectWildAfterFirstOrigin() {
        OriginEntity firstOriginEntity = this.newOriginEntity();
        Attributes firstOriginAttributes = this.getAttributes((Entity)firstOriginEntity).get();
        firstOriginAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        OriginEntity otherOriginEntity = this.newOriginEntity();
        Attributes otherOriginAttributes = this.getAttributes((Entity)otherOriginEntity).get();
        otherOriginAttributes.add("SOCKET_ADDRESS", (Object)"*");
        boolean firstOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)firstOriginEntity, firstOriginAttributes);
        this.expectLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
        boolean otherOriginAccepted = this.getServerContext().addRemoteOrigin((Origin)otherOriginEntity, otherOriginAttributes);
        Require.success((boolean)firstOriginAccepted, (Object)"first origin accepted");
        Require.failure((boolean)otherOriginAccepted, (Object)"other origin accepted");
        this.requireLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
    }

    @Test(priority=30)
    public void shouldRejectWildAfterNodeAddress() {
        OriginEntity originEntity = this.newOriginEntity();
        Attributes originAttributes = this.getAttributes((Entity)originEntity).get();
        originAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        originAttributes.add("SOCKET_ADDRESS", (Object)"*");
        this.expectLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
        boolean originAccepted = this.getServerContext().addRemoteOrigin((Origin)originEntity, originAttributes);
        Require.failure((boolean)originAccepted, (Object)"origin accepted");
        this.requireLogs(new Messages.Entry[]{PAPMessages.WILDCARD_ADDRESS_RESTRICTS});
    }

    @Test(priority=130)
    public void shouldRequirePointAddress() {
        OriginEntity originEntity = this.newOriginEntity();
        Attributes originAttributes = this.getAttributes((Entity)originEntity).get();
        originAttributes.add("SOCKET_ADDRESS", (Object)"127.0.0.1");
        Require.success((boolean)this.getServerContext().addRemoteOrigin((Origin)originEntity, originAttributes));
        Point point = this.newPoint(Optional.of(originEntity));
        this.expectLogs(new Messages.Entry[]{ModbusMessages.NO_ADDRESS});
        boolean pointAccepted = this.getServerContext().addRemotePoint(point, this.getAttributes((Entity)point).get());
        Require.failure((boolean)pointAccepted, (Object)"point accepted");
        this.requireLogs(new Messages.Entry[]{ModbusMessages.NO_ADDRESS});
    }

    protected ModbusServerContext getServerContext() {
        return this._serverContext;
    }
}

