/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.modbus;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.modbus.ModbusClient;
import org.rvpf.pap.modbus.ModbusClientContext;
import org.rvpf.pap.modbus.ModbusClientProxy;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.ModbusServer;
import org.rvpf.pap.modbus.ModbusServerContext;
import org.rvpf.pap.modbus.ModbusSupport;
import org.rvpf.pap.modbus.register.Register;
import org.rvpf.tests.pap.PAPTestsSupport;

public final class ModbusTestsSupport
extends PAPTestsSupport {
    public static final String LISTEN_PORT_PROPERTY = "tests.modbus.listen.port";
    private static final String _MODBUS_ORIGIN_NAME = "TestsModbus";
    private static final String _SERIAL_LISTENER_PROPERTIES = "modbus.listener.serial";
    private static final String _SOCKET_LISTENER_PROPERTIES = "modbus.listener.socket";
    private final ModbusClient _client;
    private final Map<Point, Register> _coilsByPoint = new HashMap<Point, Register>();
    private final Map<Point, Register> _discretesByPoint = new HashMap<Point, Register>();
    private final Map<Point, Register> _inputsByPoint = new HashMap<Point, Register>();
    private final Map<Point, Register> _registersByPoint = new HashMap<Point, Register>();
    private final ModbusClientProxy _remoteProxy;
    private final ModbusServer _server;
    private volatile boolean _serverLocal;
    private final Origin _serverOrigin;

    public ModbusTestsSupport(@Nonnull Metadata metadata) {
        super(Optional.of(metadata));
        KeyedGroups serverProperties;
        ModbusSupport support = new ModbusSupport();
        KeyedGroups socketProperties = metadata.getPropertiesGroup(_SOCKET_LISTENER_PROPERTIES);
        KeyedGroups serialProperties = metadata.getPropertiesGroup(_SERIAL_LISTENER_PROPERTIES);
        ModbusServerContext serverContext = support.newServerContext(metadata, new String[]{_MODBUS_ORIGIN_NAME}, Optional.empty());
        Require.notNull((Object)serverContext);
        this._server = support.newServer((PAPContext)serverContext);
        if (!socketProperties.isEmpty()) {
            serverProperties = new KeyedGroups();
            serverProperties.addGroup("listener", socketProperties);
            Require.success((boolean)this._server.setUp(serverProperties));
        }
        if (!serialProperties.isEmpty()) {
            serverProperties = new KeyedGroups();
            serverProperties.addGroup("listener", serialProperties);
            Require.success((boolean)this._server.setUp(serverProperties));
        }
        ModbusClientContext clientContext = support.newClientContext(metadata, Optional.empty());
        Require.notNull((Object)clientContext);
        this._client = support.newClient((PAPContext)clientContext);
        Require.notNull((Object)this._client);
        this._serverOrigin = (Origin)this._client.getOrigin(Optional.of(_MODBUS_ORIGIN_NAME)).get();
        this._remoteProxy = (ModbusClientProxy)this._server.getClientProxy(this._serverOrigin).get();
        for (Register register : this._remoteProxy.getCoils()) {
            for (Point point : register.getPoints()) {
                this._coilsByPoint.put(point, register);
            }
        }
        for (Register register : this._remoteProxy.getDiscretes()) {
            for (Point point : register.getPoints()) {
                this._discretesByPoint.put(point, register);
            }
        }
        for (Register register : this._remoteProxy.getInputs()) {
            for (Point point : register.getPoints()) {
                this._inputsByPoint.put(point, register);
            }
        }
        for (Register register : this._remoteProxy.getRegisters()) {
            for (Point point : register.getPoints()) {
                this._registersByPoint.put(point, register);
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    public ModbusClient getClient() {
        return this._client;
    }

    @Nonnull
    @CheckReturnValue
    public Map<Point, Register> getCoilsByPoint() {
        return this._coilsByPoint;
    }

    @Nonnull
    @CheckReturnValue
    public Map<Point, Register> getDiscretesByPoint() {
        return this._discretesByPoint;
    }

    @Nonnull
    @CheckReturnValue
    public Map<Point, Register> getInputsByPoint() {
        return this._inputsByPoint;
    }

    @Nonnull
    @CheckReturnValue
    public Point getPoint(@Nonnull String key) {
        return (Point)this.getMetadata().get().getPoint(key).get();
    }

    @Nonnull
    @CheckReturnValue
    public Map<Point, Register> getRegistersByPoint() {
        return this._registersByPoint;
    }

    @Nonnull
    @CheckReturnValue
    public ModbusProxy getRemoteProxy() {
        return this._remoteProxy;
    }

    @Nonnull
    @CheckReturnValue
    public ModbusServer getServer() {
        this._serverLocal = true;
        return this._server;
    }

    @Nonnull
    @CheckReturnValue
    public Origin getServerOrigin() {
        return this._serverOrigin;
    }

    @CheckReturnValue
    public boolean isServerLocal() {
        return this._serverLocal;
    }
}

