/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.processor.engine.pap.modbus;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.processor.ProcessorServiceActivator;
import org.rvpf.service.ServiceActivator;
import org.rvpf.tests.store.StoreClientTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class SplitterEngineTests
extends StoreClientTests {
    private static final String _SPLITTED_POINT = "TESTS-MODBUS.SPLITTED.1";
    private static final String _SPLIT_POINT_1 = "TESTS-MODBUS.SPLIT.1";
    private static final String _SPLIT_POINT_2 = "TESTS-MODBUS.SPLIT.2";
    private static final String _SPLIT_POINT_3 = "TESTS-MODBUS.SPLIT.3";
    private static final String _SPLIT_POINT_4 = "TESTS-MODBUS.SPLIT.4";
    private static final String _TESTS_PROPERTIES = "rvpf-modbus.properties";
    private ServiceActivator _processorService;
    private StoreSessionProxy _storeProxy;
    private ServiceActivator _storeService;

    @BeforeClass
    public void setUp() throws Exception {
        SplitterEngineTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        this.setUpAlerter();
        Require.notNull((Object)this.getMetadata(true));
        this._storeService = this.startStoreService(true);
        this._storeProxy = this.getStoreProxy(this._storeService);
        this._processorService = this.createService(ProcessorServiceActivator.class, Optional.empty());
        SplitterEngineTests.startService((ServiceActivator)this._processorService);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this._processorService != null) {
            this.stopService(this._processorService);
            this._processorService = null;
        }
        this._storeProxy.disconnect();
        if (this._storeService != null) {
            this.stopService(this._storeService);
            this._storeService = null;
        }
        this.tearDownAlerter();
    }

    @Test
    public void test() throws Exception {
        Point splitPoint1 = this.getPoint(_SPLIT_POINT_1);
        Point splitPoint2 = this.getPoint(_SPLIT_POINT_2);
        Point splitPoint3 = this.getPoint(_SPLIT_POINT_3);
        Point splitPoint4 = this.getPoint(_SPLIT_POINT_4);
        UUID[] subscribed = new UUID[]{(UUID)splitPoint1.getUUID().get(), (UUID)splitPoint2.getUUID().get(), (UUID)splitPoint3.getUUID().get(), (UUID)splitPoint4.getUUID().get()};
        Require.success((boolean)this._storeProxy.subscribeAndCheck(subscribed, this.getThisLogger()));
        Point splittedPoint = this.getPoint(_SPLITTED_POINT);
        Tuple registers = new Tuple();
        registers.add((Serializable)Short.valueOf((short)-1));
        registers.add((Serializable)Short.valueOf((short)-1));
        registers.add((Serializable)Short.valueOf((short)-1));
        registers.add((Serializable)Short.valueOf((short)2));
        PointValue splittedPointValue = new PointValue(splittedPoint, Optional.of(DateTime.now()), null, (Serializable)registers);
        Require.success((boolean)this._storeProxy.updateAndCheck(splittedPointValue, this.getThisLogger()));
        StoreValues response = this._storeProxy.deliver(100, (long)this.getTimeout());
        Require.success((boolean)response.isSuccess());
        Require.equal((long)4L, (long)response.size());
        PointValue splitPointValue1 = response.getPointValue(0);
        Require.equal((Object)splitPointValue1.getStamp(), (Object)splittedPointValue.getStamp());
        Require.equal((Object)splitPointValue1.getValue(), (Object)65535L);
        PointValue splitPointValue2 = response.getPointValue(1);
        Require.equal((Object)splitPointValue2.getStamp(), (Object)splittedPointValue.getStamp());
        Require.equal((Object)splitPointValue2.getValue(), (Object)-1L);
        PointValue splitPointValue3 = response.getPointValue(2);
        Require.equal((Object)splitPointValue3.getStamp(), (Object)splittedPointValue.getStamp());
        Require.equal((Object)splitPointValue3.getValue(), (Object)Boolean.FALSE);
        PointValue splitPointValue4 = response.getPointValue(3);
        Require.equal((Object)splitPointValue4.getStamp(), (Object)splittedPointValue.getStamp());
        Require.equal((Object)splitPointValue4.getValue(), (Object)Boolean.TRUE);
        Require.success((boolean)this._storeProxy.unsubscribeAndCheck(subscribed, this.getThisLogger()));
    }
}

