/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.service.pap.datalogger.cip;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.Attributes;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.cip.CIPClient;
import org.rvpf.pap.cip.CIPSupport;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.pap.datalogger.DataloggerServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DataloggerServiceTests
extends MetadataServiceTests {
    private static final String _CIP_NAME = "CIP";
    private static final String _SINK_QUEUE_NAME = "TestsSink";
    private static final String _TESTS_PROPERTIES = "rvpf-cip-datalogger.properties";
    private static final String _TESTS_REGISTER_1 = "TESTS-CIP.REGISTER.1";
    private static final String _TESTS_REPLICATED_PROPERTY = "tests.replicated";
    private static final String _TESTS_SCANNED_1 = "TESTS-CIP.SCANNED.1";
    private static final String _TESTS_SPLITTED_1 = "TESTS-CIP.SPLITTED.1";
    private static final String _TESTS_SPLITTED_2 = "TESTS-CIP.SPLITTED.2";
    private static final String _TESTS_SPLITTED_3 = "TESTS-CIP.SPLITTED.3";
    private static final String _TESTS_SPLIT_0_1 = "TESTS-CIP.SPLIT.0.1";
    private static final String _TESTS_SPLIT_0_2 = "TESTS-CIP.SPLIT.0.2";
    private static final String _TESTS_SPLIT_1_1 = "TESTS-CIP.SPLIT.1.1";
    private static final String _TESTS_SPLIT_1_2 = "TESTS-CIP.SPLIT.1.2";
    private static final String _TESTS_SPLIT_1_3 = "TESTS-CIP.SPLIT.1.3";
    private static final String _TESTS_SPLIT_2_1 = "TESTS-CIP.SPLIT.2.1";
    private static final String _TESTS_SPLIT_2_2 = "TESTS-CIP.SPLIT.2.2";
    private static final String _TESTS_SPLIT_3_1 = "TESTS-CIP.SPLIT.3.1";
    private static final String _TESTS_SPLIT_3_2 = "TESTS-CIP.SPLIT.3.2";
    private static final String _TESTS_STATE_1 = "TESTS-CIP.STATE.1";
    private MessagingSupport.Receiver _somReceiver;

    @BeforeClass
    public void setUp() throws Exception {
        DataloggerServiceTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        DataloggerServiceTests.setProperty((String)_TESTS_REPLICATED_PROPERTY, (String)"1");
        DateTime.simulateTime((DateTime)DateTime.now().midnight());
        DataloggerServiceTests.setProperty((String)"tests.cip.listen.port", (String)String.valueOf(DataloggerServiceTests.allocateTCPPort()));
        this.setUpAlerter();
        this._somReceiver = this.getMessaging().createServerReceiver(_SINK_QUEUE_NAME);
        Metadata metadata = this.getMetadata(true);
        CIPSupport support = new CIPSupport();
        CIPClient client = support.newClient((PAPContext)support.newClientContext(metadata, Optional.empty()));
        Point registerPoint = (Point)metadata.getPoint(_TESTS_REGISTER_1).get();
        PointValue registerPointValue = new PointValue(registerPoint, Optional.empty(), null, (Serializable)Integer.valueOf(12345));
        Require.present((Optional)client.requestPointUpdate(registerPointValue));
        Point dintArrayPoint = (Point)metadata.getPoint(_TESTS_SPLITTED_1).get();
        Attributes dintArrayAttributes = (Attributes)dintArrayPoint.getAttributes(_CIP_NAME).get();
        int dintArrayElements = dintArrayAttributes.getInt("ELEMENTS", 0);
        Tuple dintArray = new Tuple(dintArrayElements);
        for (int index = 0; index < dintArrayElements; ++index) {
            dintArray.add((Serializable)Integer.valueOf(index));
        }
        PointValue dintArrayPointValue = new PointValue(dintArrayPoint, Optional.empty(), null, (Serializable)dintArray);
        Require.present((Optional)client.requestPointUpdate(dintArrayPointValue));
        Point boolArrayPoint = (Point)metadata.getPoint(_TESTS_SPLITTED_2).get();
        Attributes boolArrayAttributes = (Attributes)boolArrayPoint.getAttributes(_CIP_NAME).get();
        int boolArrayElements = boolArrayAttributes.getInt("ELEMENTS", 0);
        Tuple boolArray = new Tuple(boolArrayElements);
        for (int index = 0; index < boolArrayElements; ++index) {
            boolArray.add((Serializable)Boolean.valueOf((index & 1) == 0));
        }
        PointValue boolArrayPointValue = new PointValue(boolArrayPoint, Optional.empty(), null, (Serializable)boolArray);
        Require.present((Optional)client.requestPointUpdate(boolArrayPointValue));
        Point realArrayPoint = (Point)metadata.getPoint(_TESTS_SPLITTED_3).get();
        Attributes realArrayAttributes = (Attributes)realArrayPoint.getAttributes(_CIP_NAME).get();
        int realArrayElements = realArrayAttributes.getInt("ELEMENTS", 0);
        Tuple realArray = new Tuple(realArrayElements);
        for (int index = 0; index < realArrayElements; ++index) {
            realArray.add((Serializable)Float.valueOf((float)((double)index + 0.5)));
        }
        PointValue realArrayPointValue = new PointValue(realArrayPoint, Optional.empty(), null, (Serializable)realArray);
        Require.present((Optional)client.requestPointUpdate(realArrayPointValue));
        Require.notNull((Object)client.commitPointUpdateRequests());
        client.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._somReceiver.close();
        this.tearDownAlerter();
        DateTime.clearSimulatedTime();
        DataloggerServiceTests.restoreSystemProperties();
    }

    @Test
    public void test() throws Exception {
        ServiceActivator dataloggerService = this.startService(DataloggerServiceActivator.class, Optional.of(_CIP_NAME));
        try {
            this._receive(_TESTS_STATE_1, null);
            this._receive(_TESTS_STATE_1, Boolean.TRUE);
            this._receive(_TESTS_SCANNED_1, Long.valueOf(12345L));
            this._receive(_TESTS_SPLIT_0_1, Boolean.FALSE);
            this._receive(_TESTS_SPLIT_0_2, Boolean.TRUE);
            this._receive(_TESTS_SPLIT_1_1, Long.valueOf(1L));
            this._receive(_TESTS_SPLIT_1_2, Long.valueOf(2L));
            this._receive(_TESTS_SPLIT_1_3, Boolean.TRUE);
            this._receive(_TESTS_SPLIT_2_1, Boolean.FALSE);
            this._receive(_TESTS_SPLIT_2_2, Boolean.TRUE);
            this._receive(_TESTS_SPLIT_3_1, Double.valueOf(1.5));
            this._receive(_TESTS_SPLIT_3_2, Double.valueOf(2.5));
            this._somReceiver.commit();
        }
        finally {
            this.stopService(dataloggerService);
        }
        this._receive(_TESTS_STATE_1, Boolean.FALSE);
    }

    private void _receive(String pointName, Serializable expectedValue) throws Exception {
        Point point = (Point)this.getMetadata().getPoint(pointName).get();
        Serializable serializable = this._somReceiver.receive((long)this.getTimeout());
        Require.notNull((Object)serializable, (Object)("Expected: " + pointName));
        PointValue pointValue = (PointValue)serializable;
        Serializable receivedValue = pointValue.getValue();
        String receivedValueClass = receivedValue != null ? receivedValue.getClass().getSimpleName() : "null";
        Require.equal((Object)pointValue.getStamp(), (Object)DateTime.now());
        Require.equal(null, (Object)pointValue.getState());
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Require.equal((Object)receivedValue, (Object)expectedValue, (Object)(pointName + ": " + receivedValueClass));
    }
}

