/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.service.pap.datalogger.modbus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPProxy;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.pap.datalogger.DataloggerServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.pap.modbus.ModbusTestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DataloggerConnectTests
extends MetadataServiceTests
implements PAPProxy.Responder {
    private static final String _MODBUS_NAME = "Modbus";
    private static final String _SINK_QUEUE_NAME = "TestsSink";
    private static final String _TESTS_CONNECT_PROPERTY = "tests.modbus.datalogger.connect";
    private static final String _TESTS_PROPERTIES = "rvpf-modbus-datalogger.properties";
    private static final String _TESTS_REGISTER_1 = "TESTS-MODBUS.REGISTER.1";
    private static final String _TESTS_SCANNED_1 = "TESTS-MODBUS.SCANNED.1";
    private static final String _TESTS_STATE_1 = "TESTS-MODBUS.STATE.1";
    private ModbusTestsSupport _modbusSupport;
    private final Map<Point, PointValue> _pointValues = new HashMap<Point, PointValue>();
    private MessagingSupport.Receiver _somSinkReceiver;
    private DateTime _startTime;

    public PointValue[] select(Point[] points) {
        PointValue[] pointValues = new PointValue[points.length];
        for (int i = 0; i < pointValues.length; ++i) {
            pointValues[i] = this._pointValues.get(points[i]);
        }
        return pointValues;
    }

    @BeforeClass
    public void setUp() throws Exception {
        DataloggerConnectTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        DateTime.simulateTime((DateTime)DateTime.now().midnight());
        DataloggerConnectTests.setProperty((String)"tests.modbus.listen.port", (String)String.valueOf(DataloggerConnectTests.allocateTCPPort()));
        DataloggerConnectTests.setProperty((String)_TESTS_CONNECT_PROPERTY, (String)"");
        this.setUpAlerter();
        this._somSinkReceiver = this.getMessaging().createServerReceiver(_SINK_QUEUE_NAME);
        this._modbusSupport = new ModbusTestsSupport(this.getMetadata(true));
        Point registerPoint = (Point)this.getMetadata().getPoint(_TESTS_REGISTER_1).get();
        this._pointValues.put(registerPoint, new PointValue(registerPoint, Optional.empty(), null, (Serializable)Integer.valueOf(12345)));
        this._modbusSupport.getServer().setResponder((PAPProxy.Responder)this);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._somSinkReceiver.close();
        this.tearDownAlerter();
        DateTime.clearSimulatedTime();
        DataloggerConnectTests.restoreSystemProperties();
    }

    @Test
    public void test() throws Exception {
        this._startTime = DateTime.now();
        this._modbusSupport.getServer().start();
        ServiceActivator dataloggerService = this.startService(DataloggerServiceActivator.class, Optional.of(_MODBUS_NAME));
        try {
            this._receive(_TESTS_STATE_1, null);
            this._receive(_TESTS_STATE_1, Boolean.TRUE);
            this._receive(_TESTS_SCANNED_1, Long.valueOf(12345L));
            this._somSinkReceiver.commit();
            this._modbusSupport.getServer().stop();
            this._receive(_TESTS_STATE_1, Boolean.FALSE);
        }
        finally {
            this.stopService(dataloggerService);
        }
    }

    private void _receive(String pointName, Serializable expectedValue) throws Exception {
        Point point = (Point)this.getMetadata().getPoint(pointName).get();
        Serializable serializable = this._somSinkReceiver.receive((long)this.getTimeout());
        Require.notNull((Object)serializable, (Object)("Expected: " + pointName));
        PointValue pointValue = (PointValue)serializable;
        Serializable receivedValue = pointValue.getValue();
        String receivedValueClass = receivedValue != null ? receivedValue.getClass().getSimpleName() : "null";
        Require.success((boolean)pointValue.getStamp().isNotBefore(this._startTime));
        Require.equal(null, (Object)pointValue.getState());
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Require.equal((Object)receivedValue, (Object)expectedValue, (Object)(pointName + ": " + receivedValueClass));
    }
}

