/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.service.pap.datalogger.modbus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.modbus.ModbusServer;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.pap.datalogger.DataloggerServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.pap.modbus.ModbusTestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class DataloggerServiceTests
extends MetadataServiceTests
implements PAPProxy.Responder {
    private static final String _DATALOGGER_QUEUE_PROPERTY = "tests.datalogger.queue";
    private static final String _FORWARDER_QUEUE_PROPERTIES = "tests.forwarder.queue";
    private static final String _MODBUS_NAME = "Modbus";
    private static final String _SINK_QUEUE_NAME = "TestsSink";
    private static final String _TESTS_PROPERTIES = "rvpf-modbus-datalogger.properties";
    private static final String _TESTS_REGISTER_1 = "TESTS-MODBUS.REGISTER.1";
    private static final String _TESTS_SCANNED_1 = "TESTS-MODBUS.SCANNED.1";
    private static final String _TESTS_SPLITTED_1 = "TESTS-MODBUS.SPLITTED.1";
    private static final String _TESTS_SPLITTED_2 = "TESTS-MODBUS.SPLITTED.2";
    private static final String _TESTS_SPLITTED_3 = "TESTS-MODBUS.SPLITTED.3";
    private static final String _TESTS_SPLITTED_4 = "TESTS-MODBUS.SPLITTED.4";
    private static final String _TESTS_SPLIT_1_1 = "TESTS-MODBUS.SPLIT.1.1";
    private static final String _TESTS_SPLIT_1_2 = "TESTS-MODBUS.SPLIT.1.2";
    private static final String _TESTS_SPLIT_1_3 = "TESTS-MODBUS.SPLIT.1.3";
    private static final String _TESTS_SPLIT_1_4 = "TESTS-MODBUS.SPLIT.1.4";
    private static final String _TESTS_SPLIT_1_5 = "TESTS-MODBUS.SPLIT.1.5";
    private static final String _TESTS_SPLIT_2_1 = "TESTS-MODBUS.SPLIT.2.1";
    private static final String _TESTS_SPLIT_2_2 = "TESTS-MODBUS.SPLIT.2.2";
    private static final String _TESTS_SPLIT_3_1 = "TESTS-MODBUS.SPLIT.3.1";
    private static final String _TESTS_SPLIT_4_1 = "TESTS-MODBUS.SPLIT.4.1";
    private static final String _TESTS_SPLIT_4_2 = "TESTS-MODBUS.SPLIT.4.2";
    private static final String _TESTS_STATE_1 = "TESTS-MODBUS.STATE.1";
    private ModbusTestsSupport _modbusSupport;
    private final Map<Point, PointValue> _pointValues = new HashMap<Point, PointValue>();
    private MessagingSupport.Receiver _somReceiver;
    private MessagingSupport.Receiver _somSinkReceiver;
    private DateTime _startTime;

    public PointValue[] select(Point[] points) {
        PointValue[] pointValues = new PointValue[points.length];
        for (int i = 0; i < pointValues.length; ++i) {
            pointValues[i] = this._pointValues.get(points[i]);
        }
        return pointValues;
    }

    @BeforeClass
    public void setUp() throws Exception {
        DataloggerServiceTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        DateTime.simulateTime((DateTime)DateTime.now().midnight());
        DataloggerServiceTests.setProperty((String)"tests.modbus.listen.port", (String)String.valueOf(DataloggerServiceTests.allocateTCPPort()));
        this.setUpAlerter();
        this._somSinkReceiver = this.getMessaging().createServerReceiver(_SINK_QUEUE_NAME);
        this._modbusSupport = new ModbusTestsSupport(this.getMetadata(true));
        Point registerPoint = (Point)this.getMetadata().getPoint(_TESTS_REGISTER_1).get();
        this._pointValues.put(registerPoint, new PointValue(registerPoint, Optional.empty(), null, (Serializable)Integer.valueOf(12345)));
        Point splittedPoint1 = (Point)this.getMetadata().getPoint(_TESTS_SPLITTED_1).get();
        Tuple registers = new Tuple();
        registers.add((Serializable)Short.valueOf((short)-1));
        registers.add((Serializable)Short.valueOf((short)22136));
        registers.add((Serializable)Short.valueOf((short)4660));
        registers.add((Serializable)Short.valueOf((short)2));
        registers.add((Serializable)Short.valueOf((short)Float.floatToIntBits(1.2345f)));
        registers.add((Serializable)Short.valueOf((short)(Float.floatToIntBits(1.2345f) >>> 16)));
        this._pointValues.put(splittedPoint1, new PointValue(splittedPoint1, Optional.empty(), null, (Serializable)registers));
        Point splittedPoint2 = (Point)this.getMetadata().getPoint(_TESTS_SPLITTED_2).get();
        this._pointValues.put(splittedPoint2, new PointValue(splittedPoint2, Optional.empty(), null, (Serializable)Short.valueOf((short)456)));
        Point splittedPoint3 = (Point)this.getMetadata().getPoint(_TESTS_SPLITTED_3).get();
        this._pointValues.put(splittedPoint3, new PointValue(splittedPoint3, Optional.empty(), null, (Serializable)Short.valueOf((short)789)));
        Point splittedPoint4 = (Point)this.getMetadata().getPoint(_TESTS_SPLITTED_4).get();
        Tuple bits = new Tuple();
        bits.add((Serializable)Boolean.TRUE);
        bits.add((Serializable)Boolean.FALSE);
        bits.add((Serializable)Boolean.TRUE);
        bits.add((Serializable)Boolean.FALSE);
        bits.add((Serializable)Boolean.TRUE);
        bits.add((Serializable)Boolean.FALSE);
        this._pointValues.put(splittedPoint4, new PointValue(splittedPoint4, Optional.empty(), null, (Serializable)bits));
        ModbusServer server = this._modbusSupport.getServer();
        server.setResponder((PAPProxy.Responder)this);
        server.start();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._modbusSupport.getServer().stop();
        this._somSinkReceiver.close();
        this.tearDownAlerter();
        DateTime.clearSimulatedTime();
        DataloggerServiceTests.restoreSystemProperties();
    }

    @Test
    public void testToQueue() throws Exception {
        this._somReceiver = this.getMessaging().createServerReceiver(this.getConfig().getPropertiesGroup(_FORWARDER_QUEUE_PROPERTIES));
        DataloggerServiceTests.setProperty((String)_DATALOGGER_QUEUE_PROPERTY, (String)_FORWARDER_QUEUE_PROPERTIES);
        try {
            this._test();
        }
        finally {
            this._somReceiver.close();
            this._somReceiver = null;
            DataloggerServiceTests.clearProperty((String)_DATALOGGER_QUEUE_PROPERTY);
        }
    }

    @Test
    public void testToSink() throws Exception {
        this._somReceiver = this._somSinkReceiver;
        try {
            this._test();
        }
        finally {
            this._somReceiver = null;
        }
    }

    private void _receive(String pointName, Serializable expectedValue) throws Exception {
        Point point = (Point)this.getMetadata().getPoint(pointName).get();
        Serializable serializable = this._somReceiver.receive((long)this.getTimeout());
        Require.notNull((Object)serializable, (Object)("Expected: " + pointName));
        PointValue pointValue = (PointValue)serializable;
        Serializable receivedValue = pointValue.getValue();
        String receivedValueClass = receivedValue != null ? receivedValue.getClass().getSimpleName() : "null";
        Require.success((boolean)pointValue.getStamp().isNotBefore(this._startTime));
        Require.equal(null, (Object)pointValue.getState());
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Require.equal((Object)receivedValue, (Object)expectedValue, (Object)(pointName + ": " + receivedValueClass));
    }

    private void _test() throws Exception {
        this._startTime = DateTime.now();
        ServiceActivator dataloggerService = this.startService(DataloggerServiceActivator.class, Optional.of(_MODBUS_NAME));
        try {
            this._receive(_TESTS_STATE_1, null);
            this._receive(_TESTS_STATE_1, Boolean.TRUE);
            this._receive(_TESTS_SCANNED_1, Long.valueOf(12345L));
            this._receive(_TESTS_SPLIT_1_1, Long.valueOf(65535L));
            this._receive(_TESTS_SPLIT_1_2, Long.valueOf(305419896L));
            this._receive(_TESTS_SPLIT_1_3, Boolean.FALSE);
            this._receive(_TESTS_SPLIT_1_4, Boolean.TRUE);
            this._receive(_TESTS_SPLIT_1_5, Double.valueOf(1.2345f));
            this._receive(_TESTS_SPLIT_2_1, Long.valueOf(456L));
            this._receive(_TESTS_SPLIT_2_2, Double.valueOf(456.0));
            this._receive(_TESTS_SPLIT_3_1, Long.valueOf(789L));
            this._receive(_TESTS_SPLIT_4_1, Boolean.TRUE);
            this._receive(_TESTS_SPLIT_4_2, Boolean.FALSE);
            this._somReceiver.commit();
        }
        finally {
            this.stopService(dataloggerService);
        }
        this._receive(_TESTS_STATE_1, Boolean.FALSE);
    }
}

