/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.util.zip.Checksum;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class CRC16
implements Checksum {
    private short _crc;

    @Override
    public long getValue() {
        return 0xFFFF & this._crc;
    }

    public String toString() {
        return "0X" + Long.toHexString(this.getValue());
    }

    @Override
    public final void update(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int length) {
        while (--length >= 0) {
            this.update(bytes[offset++]);
        }
    }

    @Nonnull
    @CheckReturnValue
    protected static short[] table(int polynomial) {
        short[] table = new short[256];
        for (int i = 0; i < table.length; ++i) {
            int crc = 0;
            int c = i;
            for (int j = 0; j < 8; ++j) {
                crc = ((crc ^ c) & 1) != 0 ? crc >> 1 ^ polynomial : crc >> 1;
                c >>= 1;
            }
            table[i] = (short)crc;
        }
        return table;
    }

    protected final void reset(short crc) {
        this._crc = crc;
    }

    protected final void update(byte aByte, @Nonnull short[] table) {
        this._crc = (short)(table[(this._crc ^ aByte) & 0xFF] ^ this._crc >> 8 & 0xFF);
    }
}

