/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.ListenerManager;
import org.rvpf.pap.PAPProxy;

public interface PAPConnectionListener {
    @CheckReturnValue
    public boolean onLostConnection(@Nonnull PAPProxy var1, @Nonnull Optional<Exception> var2);

    @CheckReturnValue
    public boolean onNewConnection(@Nonnull PAPProxy var1);

    public static class Manager
    extends ListenerManager<PAPConnectionListener>
    implements PAPConnectionListener {
        @Override
        public boolean onLostConnection(PAPProxy remoteProxy, Optional<Exception> cause) {
            for (PAPConnectionListener listener : this.getListeners()) {
                if (!listener.onLostConnection(remoteProxy, cause)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onNewConnection(PAPProxy remoteProxy) {
            for (PAPConnectionListener listener : this.getListeners()) {
                if (!listener.onNewConnection(remoteProxy)) continue;
                return true;
            }
            return false;
        }
    }
}

