/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;

public interface PAPServer {
    public void addPointValue(@Nonnull PointValue var1);

    @Nonnull
    @CheckReturnValue
    public Optional<PAPProxy.Responder> getResponder();

    @Nonnull
    @CheckReturnValue
    public Logger getThisLogger();

    @CheckReturnValue
    public boolean isUpdating();

    @Nonnull
    @CheckReturnValue
    public Optional<PointValue> nextUpdate(long var1) throws InterruptedException;

    public void setResponder(@Nonnull PAPProxy.Responder var1);

    @CheckReturnValue
    public boolean setUp(@Nonnull KeyedGroups var1);

    @CheckReturnValue
    public boolean setUpListener(@Nonnull KeyedGroups var1);

    public void start();

    public void stop();

    public void tearDown();

    public static abstract class Abstract
    implements PAPServer {
        private final Logger _logger = Logger.getInstance(this.getClass());
        private PAPProxy.Responder _responder;

        protected Abstract() {
        }

        @Override
        public Optional<PAPProxy.Responder> getResponder() {
            return Optional.ofNullable(this._responder);
        }

        @Override
        public Logger getThisLogger() {
            return this._logger;
        }

        @Override
        public void setResponder(PAPProxy.Responder responder) {
            this._responder = (PAPProxy.Responder)Require.notNull((Object)responder);
        }

        @Override
        public boolean setUp(KeyedGroups serverProperties) {
            boolean success;
            KeyedGroups[] listenersProperties = serverProperties.getGroups("listener");
            boolean bl = success = listenersProperties.length > 0;
            if (!success) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.NO_LISTENERS, new Object[0]);
            }
            for (KeyedGroups listenerProperties : listenersProperties) {
                success &= this.setUpListener(listenerProperties);
            }
            return success;
        }

        @Nonnull
        @CheckReturnValue
        protected abstract PAPContext getContext();
    }
}

