/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.ClassDef;
import org.rvpf.base.UUID;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPClient;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPServer;
import org.rvpf.processor.engine.pap.PAPSplitter;

public interface PAPSupport {
    @Nonnull
    @CheckReturnValue
    public static PAPSupport[] getProtocolSupports(@Nonnull KeyedValues properties) {
        ClassDef[] classDefs = properties.getClassDefs("pap.support.class");
        PAPSupport[] protocolSupports = new PAPSupport[classDefs.length];
        for (int i = 0; i < protocolSupports.length; ++i) {
            protocolSupports[i] = (PAPSupport)classDefs[i].createInstance(PAPSupport.class);
        }
        return protocolSupports;
    }

    @Nonnull
    @CheckReturnValue
    public String getAttributesUsage();

    @Nonnull
    @CheckReturnValue
    public UUID getMetadataFilterUUID();

    @Nonnull
    @CheckReturnValue
    public String getProtocolName();

    @Nonnull
    @CheckReturnValue
    public PAPClient newClient(@Nonnull PAPContext var1);

    @Nullable
    @CheckReturnValue
    public PAPContext newClientContext(@Nonnull Metadata var1, @Nonnull Optional<Traces> var2);

    @Nonnull
    @CheckReturnValue
    public PAPServer newServer(@Nonnull PAPContext var1);

    @Nullable
    @CheckReturnValue
    public PAPContext newServerContext(@Nonnull Metadata var1, @Nonnull String[] var2, @Nonnull Optional<Traces> var3);

    @Nonnull
    @CheckReturnValue
    public PAPSplitter newSplitter();

    @Nonnull
    @CheckReturnValue
    public String supportedValueTypeCodes() throws SessionException;

    public static abstract class Abstract
    implements PAPSupport {
        public boolean equals(Object object) {
            return object != null && object.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

