/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.SerialPortWrapper;

public class SerialPortInputStream
extends InputStream {
    private final SerialPortWrapper _serialPort;

    public SerialPortInputStream(@Nonnull SerialPortWrapper serialPort) {
        this._serialPort = serialPort;
    }

    @Override
    public int available() throws IOException {
        return this._serialPort.available();
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = this._serialPort.read(1);
        return bytes != null ? bytes[0] : -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read;
        Require.notNull((Object)buffer);
        if (offset < 0 || length < 0 || length > buffer.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        byte[] bytes = this._serialPort.read(length);
        int n = read = bytes != null ? bytes.length : -1;
        if (read > 0) {
            System.arraycopy(bytes, 0, buffer, offset, read);
        }
        return read;
    }
}

