/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.SerialPortWrapper;

public class SerialPortOutputStream
extends OutputStream {
    private final SerialPortWrapper _serialPort;

    public SerialPortOutputStream(@Nonnull SerialPortWrapper serialPort) {
        this._serialPort = serialPort;
    }

    @Override
    public void write(int byteInt) throws IOException {
        this._serialPort.write(new byte[]{(byte)byteInt});
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        Require.notNull((Object)buffer);
        if (offset < 0 || offset > buffer.length || length < 0 || offset + length > buffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        this._serialPort.write(Arrays.copyOfRange(buffer, offset, offset + length));
    }
}

