/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.AccessDeniedException;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import jssc.SerialNativeInterface;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.pap.PAPMessages;

@ThreadSafe
public final class SerialPortWrapper
implements SerialPortEventListener {
    private static final Logger _LOGGER = Logger.getInstance(SerialPortWrapper.class);
    private int _available;
    private volatile boolean _dsr;
    private volatile int _err;
    private Optional<String> _logID;
    private final Object _mutex = new Object();
    private final Collection<OutputEmptyListener> _outputEmptyListeners = new IdentityHashSet();
    private final boolean _portControl;
    private final int _portDataBits;
    private final boolean _portModem;
    private final String _portName;
    private final int _portParity;
    private final String _portParityName;
    private final int _portSpeed;
    private final int _portStopBits;
    private volatile SerialPort _serialPort;
    private final Collection<StatusChangeListener> _statusChangeListeners = new IdentityHashSet();

    SerialPortWrapper(String portName, int portSpeed, boolean portControl, int portDataBits, int portStopBits, int portParity, String portParityName, boolean portModem) {
        this._portName = Require.notEmptyTrimmed((String)portName);
        this._portSpeed = portSpeed;
        this._portControl = portControl;
        this._portDataBits = portDataBits;
        this._portStopBits = portStopBits;
        this._portParity = portParity;
        this._portParityName = portParityName;
        this._portModem = portModem;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputEmptyListener(@Nonnull OutputEmptyListener listener) {
        Object object = this._mutex;
        synchronized (object) {
            boolean wasEmpty = this._outputEmptyListeners.isEmpty();
            this._outputEmptyListeners.add(listener);
            if (wasEmpty) {
                try {
                    this._serialPort.setEventsMask(this._serialPort.getEventsMask() | 4);
                }
                catch (SerialPortException exception) {
                    _LOGGER.warn((Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusChangeListener(@Nonnull StatusChangeListener listener) {
        Object object = this._mutex;
        synchronized (object) {
            this._statusChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public int available() {
        Object object = this._mutex;
        synchronized (object) {
            return this._available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this._mutex;
        synchronized (object) {
            SerialPort serialPort = this._serialPort;
            if (serialPort != null) {
                this._serialPort = null;
                this._dsr = false;
                this._err = 0;
                try {
                    if (this._portModem) {
                        serialPort.setDTR(false);
                    }
                    serialPort.closePort();
                    _LOGGER.debug((Messages.Entry)PAPMessages.SERIAL_PORT_CLOSED, new Object[]{this._portName});
                }
                catch (SerialPortException exception) {
                    throw new IOException(exception);
                }
                this._mutex.notifyAll();
            }
            if (serialPort != null) {
                this._callStatusChangeListeners(Event.CLOSED);
                this._statusChangeListeners.clear();
                this._outputEmptyListeners.clear();
            }
        }
    }

    @CheckReturnValue
    public boolean getDSR() {
        return this._dsr;
    }

    @CheckReturnValue
    public int getPortDataBits() {
        return this._portDataBits;
    }

    @Nonnull
    @CheckReturnValue
    public String getPortName() {
        return this._portName;
    }

    @CheckReturnValue
    public int getPortSpeed() {
        return this._portSpeed;
    }

    @CheckReturnValue
    public boolean isClosed() {
        return this._serialPort == null;
    }

    @CheckReturnValue
    public boolean isOpen() {
        return this._serialPort != null;
    }

    @CheckReturnValue
    public boolean isPortModem() {
        return this._portModem;
    }

    @CheckReturnValue
    public boolean isPortParityNone() {
        return this._portParity == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this._mutex;
        synchronized (object) {
            boolean dsr;
            Require.notNull((Object)this._portName);
            Require.failure((this._serialPort != null ? 1 : 0) != 0);
            SerialPort serialPort = new SerialPort(this._portName);
            this._logID = Logger.currentLogID();
            this._dsr = !this._portModem;
            this._err = 0;
            try {
                serialPort.openPort();
                serialPort.setParams(this._portSpeed, this._portDataBits, this._portStopBits, this._portParity, this._portControl, this._portModem);
                serialPort.setFlowControlMode(this._portControl ? 3 : 0);
                int eventMask = 129;
                if (this._portModem) {
                    eventMask |= 0x10;
                }
                serialPort.addEventListener((SerialPortEventListener)this, eventMask);
                this._available = serialPort.getInputBufferBytesCount();
                if (this._available < 0) {
                    throw new IOException();
                }
                dsr = serialPort.isDSR();
            }
            catch (SerialPortException exception) {
                if (exception.getExceptionType() == "Port not found") {
                    throw new FileNotFoundException();
                }
                if (exception.getExceptionType() == "Port busy") {
                    throw new AccessDeniedException(this._portName);
                }
                throw new IOException(exception);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this._portSpeed);
            builder.append('/');
            builder.append(this._portDataBits);
            builder.append('-');
            builder.append(this._portParityName.substring(0, 1).toUpperCase(Locale.ROOT));
            builder.append('-');
            builder.append(this._portStopBits);
            if (this._portModem) {
                builder.append("+DTR");
            }
            if (this._portControl) {
                builder.append("+RTS");
            }
            _LOGGER.info((Messages.Entry)PAPMessages.SERIAL_PORT_OPENED, new Object[]{this._portName, builder});
            this._serialPort = serialPort;
            if (this._portModem) {
                this._updateDSR(dsr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws IOException {
        Object object = this._mutex;
        synchronized (object) {
            SerialPort serialPort = this._serialPort;
            if (serialPort != null) {
                try {
                    serialPort.purgePort(12);
                }
                catch (SerialPortException exception) {
                    throw new IOException(exception);
                }
                this._available = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public byte[] read(int count) throws IOException {
        Object object = this._mutex;
        synchronized (object) {
            byte[] bytes;
            if (this.isClosed()) {
                return null;
            }
            while (this.isOpen() && this._available == 0) {
                try {
                    this._mutex.wait();
                }
                catch (InterruptedException exception) {
                    throw new InterruptedIOException();
                }
            }
            if (this.isClosed()) {
                return null;
            }
            if (this._available < 0) {
                throw new IOException();
            }
            int read = Math.min(count, this._available);
            try {
                Require.success((this._available <= this._serialPort.getInputBufferBytesCount() ? 1 : 0) != 0);
                bytes = this._serialPort.readBytes(read);
                Require.equal((long)read, (long)bytes.length);
                this._available -= read;
            }
            catch (SerialPortException exception) {
                if (exception.getExceptionType() == "Port not opened") {
                    return null;
                }
                throw new IOException(exception);
            }
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputEmptyListener(@Nonnull OutputEmptyListener listener) {
        Object object = this._mutex;
        synchronized (object) {
            if (this._outputEmptyListeners.remove(listener) && this._outputEmptyListeners.isEmpty()) {
                try {
                    this._serialPort.setEventsMask(this._serialPort.getEventsMask() & 0xFFFFFFFB);
                }
                catch (SerialPortException exception) {
                    _LOGGER.warn((Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusChangeListener(@Nonnull StatusChangeListener listener) {
        Object object = this._mutex;
        synchronized (object) {
            this._statusChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(@Nonnull SerialPortEvent serialPortEvent) {
        Object object = this._mutex;
        synchronized (object) {
            if (this._serialPort == null) {
                return;
            }
            if (this._logID.isPresent()) {
                Logger.setLogID(this._logID);
                this._logID = Optional.empty();
            }
            switch (serialPortEvent.getEventType()) {
                case 1: {
                    try {
                        this._available = this._serialPort.getInputBufferBytesCount();
                    }
                    catch (SerialPortException exception) {
                        this._available = -1;
                    }
                    if (this._available == 0) break;
                    this._mutex.notifyAll();
                    break;
                }
                case 4: {
                    this._callOutputEmptyListeners();
                    break;
                }
                case 16: {
                    Event dsrEvent = this._updateDSR(serialPortEvent.getEventValue() != 0);
                    if (dsrEvent == null) break;
                    this._callStatusChangeListeners(dsrEvent);
                    break;
                }
                case 128: {
                    this._err = serialPortEvent.getEventValue();
                    if ((this._err & 2) != 0) {
                        _LOGGER.warn((Messages.Entry)PAPMessages.OVERRUN_ERROR, new Object[]{this._serialPort.getPortName()});
                        this._callStatusChangeListeners(Event.OVERRUN);
                    }
                    if ((this._err & 8) != 0) {
                        _LOGGER.warn((Messages.Entry)PAPMessages.FRAME_ERROR, new Object[]{this._serialPort.getPortName()});
                        this._callStatusChangeListeners(Event.FRAME);
                    }
                    if ((this._err & 4) == 0) break;
                    _LOGGER.warn((Messages.Entry)PAPMessages.PARITY_ERROR, new Object[]{this._serialPort.getPortName()});
                    this._callStatusChangeListeners(Event.PARITY);
                    break;
                }
            }
        }
    }

    public void write(@Nonnull byte[] bytes) throws IOException {
        boolean succeeded;
        SerialPort serialPort = this._serialPort;
        if (serialPort == null) {
            throw new EOFException();
        }
        try {
            succeeded = serialPort.writeBytes(bytes);
        }
        catch (SerialPortException exception) {
            throw new IOException(exception);
        }
        Require.success((boolean)succeeded);
    }

    private void _callOutputEmptyListeners() {
        for (OutputEmptyListener listener : this._outputEmptyListeners) {
            listener.onOutputEmpty(this);
        }
    }

    private void _callStatusChangeListeners(Event event) {
        for (StatusChangeListener listener : this._statusChangeListeners) {
            listener.onStatusChange(this, event);
        }
    }

    private Event _updateDSR(boolean newDSR) {
        boolean oldDSR = this._dsr;
        this._dsr = newDSR;
        if (newDSR && !oldDSR) {
            _LOGGER.debug((Messages.Entry)PAPMessages.DSR_ON, new Object[]{this._serialPort.getPortName()});
            return Event.DSR_ON;
        }
        if (!newDSR && oldDSR) {
            _LOGGER.debug((Messages.Entry)PAPMessages.DSR_OFF, new Object[]{this._serialPort.getPortName()});
            return Event.DSR_OFF;
        }
        return null;
    }

    static {
        _LOGGER.debug((Messages.Entry)PAPMessages.JSSC_VERSION, new Object[]{SerialNativeInterface.getLibraryVersion()});
    }

    public static final class Builder {
        public static final int DEFAULT_DATA_BITS = 8;
        public static final int DEFAULT_PARITY = 0;
        public static final String DEFAULT_PARITY_NAME = "NONE";
        public static final int DEFAULT_PORT_SPEED = 9600;
        public static final String PARITY_NAME_EVEN = "EVEN";
        public static final String PARITY_NAME_MARK = "MARK";
        public static final String PARITY_NAME_NONE = "NONE";
        public static final String PARITY_NAME_ODD = "ODD";
        public static final String PARITY_NAME_SPACE = "SPACE";
        public static final int DEFAULT_STOP_BITS = 2;
        private boolean _portControl;
        private int _portDataBits = 8;
        private boolean _portModem;
        private String _portName;
        private int _portParity = 0;
        private String _portParityName = "NONE";
        private int _portSpeed = 9600;
        private int _portStopBits = 2;

        Builder() {
        }

        @Nonnull
        @CheckReturnValue
        public SerialPortWrapper build() {
            return new SerialPortWrapper(this._portName, this._portSpeed, this._portControl, this._portDataBits, this._portStopBits, this._portParity, this._portParityName, this._portModem);
        }

        @Nonnull
        public Builder setPortControl(boolean portControl) {
            this._portControl = portControl;
            return this;
        }

        @Nonnull
        public Builder setPortDataBits(int portDataBits) {
            this._portDataBits = portDataBits;
            return this;
        }

        @Nonnull
        public Builder setPortModem(boolean portModem) {
            this._portModem = portModem;
            return this;
        }

        @Nonnull
        public Builder setPortName(@Nonnull String portName) {
            this._portName = (String)Require.notNull((Object)portName);
            return this;
        }

        @Nonnull
        public Builder setPortParity(@Nonnull String parityName) {
            int parity = this._parity(Require.notEmptyTrimmed((String)parityName));
            this._portParity = parity < 0 ? this._parity("NONE") : parity;
            this._portStopBits = this._portParity == 0 && this._portDataBits < 8 ? 2 : 1;
            return this;
        }

        @Nonnull
        public Builder setPortSpeed(int portSpeed) {
            this._portSpeed = portSpeed;
            return this;
        }

        @Nonnull
        public Builder setPortStopBits(int portStopBits) {
            this._portStopBits = portStopBits;
            return this;
        }

        private int _parity(String parityName) {
            int parity;
            switch (parityName.toUpperCase(Locale.ROOT)) {
                case "EVEN": {
                    parity = 2;
                    break;
                }
                case "MARK": {
                    parity = 3;
                    break;
                }
                case "NONE": {
                    parity = 0;
                    break;
                }
                case "ODD": {
                    parity = 1;
                    break;
                }
                case "SPACE": {
                    parity = 4;
                    break;
                }
                default: {
                    Logger.getInstance(SerialPortWrapper.class).warn((Messages.Entry)PAPMessages.UNRECOGNIZED_PARITY, new Object[]{parityName});
                    parityName = "NONE";
                    parity = 0;
                }
            }
            this._portParityName = parityName;
            return parity;
        }
    }

    public static interface StatusChangeListener {
        public void onStatusChange(@Nonnull SerialPortWrapper var1, @Nonnull Event var2);
    }

    public static interface OutputEmptyListener {
        public void onOutputEmpty(@Nonnull SerialPortWrapper var1);
    }

    public static enum Event {
        DSR_ON,
        DSR_OFF,
        OVERRUN,
        FRAME,
        PARITY,
        CLOSED;

    }
}

