/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import javax.annotation.CheckReturnValue;

public final class TraceBuffer {
    private byte[] _buffer = new byte[514];
    private final boolean _enabled;
    private int _used;

    public TraceBuffer(boolean enabled) {
        this._enabled = enabled;
    }

    public void append(byte byteValue) {
        if (this._enabled) {
            if (this._used < this._buffer.length - 1) {
                this._buffer[this._used++] = byteValue;
            } else {
                this._buffer[this._buffer.length - 1] = -1;
            }
        }
    }

    @CheckReturnValue
    public boolean isEmpty() {
        return this._used == 0;
    }

    public void reset() {
        this._used = 0;
        this._buffer[this._buffer.length - 1] = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this._used; ++i) {
            if (i > 0) {
                stringBuilder.append('-');
            }
            byte byteValue = this._buffer[i];
            stringBuilder.append((char)TraceBuffer._halfByteToHexDigit((byte)(byteValue >> 4)));
            stringBuilder.append((char)TraceBuffer._halfByteToHexDigit(byteValue));
        }
        return stringBuilder.toString();
    }

    private static byte _halfByteToHexDigit(byte halfByte) {
        byte hexDigit = (halfByte = (byte)(halfByte & 0xF)) < 10 ? (byte)(48 + halfByte) : (byte)(65 + halfByte - 10);
        return hexDigit;
    }
}

