/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap.captor;

import org.rvpf.base.tool.Require;
import org.rvpf.processor.engine.pap.captor.CaptorTransform;
import org.rvpf.processor.engine.pap.captor.Capture;
import org.rvpf.processor.engine.rpn.Stack;
import org.rvpf.processor.engine.rpn.Task;
import org.rvpf.processor.engine.rpn.operation.Operation;
import org.rvpf.processor.engine.rpn.operation.SimpleOperation;
import org.rvpf.processor.engine.rpn.selector.SelectorOperations;

public final class CaptorOperations
extends SelectorOperations {
    public void execute(Task task, SimpleOperation.Reference reference) throws Task.ExecuteException, Stack.LimitsException {
        Object referenceCode = reference.getCode();
        if (!(referenceCode instanceof _Code)) {
            super.execute(task, reference);
            return;
        }
        CaptorTransform.Context context = (CaptorTransform.Context)task.getContext();
        Capture capture = context.getCapture();
        Stack stack = task.getStack();
        switch ((_Code)((Object)referenceCode)) {
            case LIMIT_AFTER: {
                CaptorOperations._doLimitAfter(capture, stack);
                break;
            }
            case LIMIT_BEFORE: {
                CaptorOperations._doLimitBefore(capture, stack);
                break;
            }
            case TIME_AFTER: {
                CaptorOperations._doTimeAfter(capture, stack);
                break;
            }
            case TIME_BEFORE: {
                CaptorOperations._doTimeBefore(capture, stack);
                break;
            }
            default: {
                Require.failure();
            }
        }
    }

    protected void setUp() throws Operation.OverloadException {
        super.setUp();
        this.register("limit>", _Code.LIMIT_AFTER);
        this.register("limit<", _Code.LIMIT_BEFORE);
        this.register("time>", _Code.TIME_AFTER);
        this.register("time<", _Code.TIME_BEFORE);
    }

    private static void _doLimitAfter(Capture capture, Stack stack) {
        stack.push((long)capture.getLimitAfter());
    }

    private static void _doLimitBefore(Capture capture, Stack stack) {
        stack.push((long)capture.getLimitBefore());
    }

    private static void _doTimeAfter(Capture capture, Stack stack) {
        stack.push(capture.getTimeAfter());
    }

    private static void _doTimeBefore(Capture capture, Stack stack) {
        stack.push(capture.getTimeBefore());
    }

    private static enum _Code {
        LIMIT_AFTER,
        LIMIT_BEFORE,
        TIME_AFTER,
        TIME_BEFORE;

    }
}

