/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.pap;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.Entity;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPMetadataFilter;
import org.rvpf.pap.PAPSupport;
import org.rvpf.service.metadata.MetadataService;
import org.rvpf.service.metadata.app.MetadataServiceAppImpl;

public abstract class PAPServiceAppImpl
extends MetadataServiceAppImpl {
    private final Map<PAPSupport, PAPContext> _protocolContexts = new IdentityHashMap<PAPSupport, PAPContext>();
    private final AtomicReference<PAPSupport[]> _protocolSupports = new AtomicReference();

    @Nullable
    @CheckReturnValue
    public PAPContext getProtocolContext(@Nonnull Point point, @Nonnull Optional<Traces> traces) {
        Optional origin = point.getOrigin();
        if (!origin.isPresent()) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ORIGIN, new Object[]{point});
            return null;
        }
        PAPContext protocolContext = this.getProtocolContext((Origin)origin.get(), traces);
        if (protocolContext != null) {
            Optional<PAPSupport> protocolSupport = this.getProtocolSupport((Entity)point);
            if (!protocolSupport.isPresent()) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.NO_PROTOCOL_FOR_ENTITY, new Object[]{point.getElementName(), point.getName()});
                return null;
            }
            if (!protocolSupport.get().equals(protocolContext.getSupport())) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.PROTOCOL_CONFLICT, new Object[]{point});
            }
        }
        return protocolContext;
    }

    public boolean onNewMetadata(Metadata metadata) {
        if (!metadata.validatePointsRelationships()) {
            return false;
        }
        return super.onNewMetadata(metadata);
    }

    public boolean setUp(MetadataService service) {
        if (!super.setUp(service)) {
            return false;
        }
        if (!this.loadMetadata()) {
            return false;
        }
        this.getMetadata().cleanUp();
        return true;
    }

    @Nonnull
    @CheckReturnValue
    protected MetadataFilter getMetadataFilter() {
        return new PAPMetadataFilter(this.getProtocolAttributesUsages());
    }

    @Nonnull
    @CheckReturnValue
    protected Set<String> getProtocolAttributesUsages() {
        PAPSupport[] protocolSupports = this.getProtocolSupports();
        HashSet<String> attributesUsages = new HashSet<String>(protocolSupports.length);
        for (PAPSupport protocolSupport : protocolSupports) {
            attributesUsages.add(protocolSupport.getAttributesUsage());
        }
        return attributesUsages;
    }

    @Nullable
    @CheckReturnValue
    protected PAPContext getProtocolContext(@Nonnull Origin origin, @Nonnull Optional<Traces> traces) {
        Optional<PAPSupport> protocolSupport = this.getProtocolSupport((Entity)origin);
        if (!protocolSupport.isPresent()) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.NO_PROTOCOL_FOR_ENTITY, new Object[]{origin.getElementName(), origin.getName()});
            return null;
        }
        PAPContext protocolContext = this._protocolContexts.get(protocolSupport.get());
        if (protocolContext == null && (protocolContext = protocolSupport.get().newClientContext(this.getMetadata(), traces)) != null) {
            this._protocolContexts.put(protocolSupport.get(), protocolContext);
        }
        return protocolContext;
    }

    @Nonnull
    @CheckReturnValue
    protected Optional<PAPSupport> getProtocolSupport(@Nonnull Entity entity) {
        for (PAPSupport protocolSupport : this.getProtocolSupports()) {
            Optional protocolAttributes = entity.getAttributes(protocolSupport.getAttributesUsage());
            if (!protocolAttributes.isPresent()) continue;
            return Optional.of(protocolSupport);
        }
        return Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    protected PAPSupport[] getProtocolSupports() {
        PAPSupport[] protocolSupports = this._protocolSupports.get();
        if (protocolSupports == null && this._protocolSupports.compareAndSet(null, protocolSupports = PAPSupport.getProtocolSupports((KeyedValues)this.getConfigProperties()))) {
            for (PAPSupport protocolSupport : protocolSupports) {
                this.getThisLogger().debug((Messages.Entry)PAPMessages.SUPPORTED_PROTOCOL, new Object[]{protocolSupport.getProtocolName()});
            }
        }
        return protocolSupports;
    }

    @CheckReturnValue
    protected boolean loadMetadata() {
        return this.loadMetadata(this.getMetadataFilter());
    }
}

