/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.pap.datalogger;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.util.Schedule;

final class ScanSchedule
extends Schedule<Schedule.PointEvent> {
    private boolean _allDue;

    public ScanSchedule() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public Collection<Schedule.PointEvent> allDue(boolean wait, boolean distinct) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        LinkedHashSet<Schedule.PointEvent> allDue = distinct ? new LinkedHashSet() : new LinkedList();
        Object object = this.getMutex();
        synchronized (object) {
            if (!this._allDue) {
                Schedule.PointEvent event;
                Schedule.PointEvent firstEvent = this.peek().orElse(null);
                while (this.hasNext() && (event = (Schedule.PointEvent)this.next(wait).orElse(null)) != null) {
                    if (event == firstEvent && !event.equals((Object)firstEvent)) {
                        this.rollback();
                        break;
                    }
                    allDue.add(event);
                    wait = false;
                }
            }
            if (wait && this._allDue) {
                for (Schedule.PointEvent event : this.getEvents()) {
                    allDue.add(event);
                }
                this._allDue = false;
            }
        }
        return allDue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resync(@Nonnull Sync sync) {
        Object object = this.getMutex();
        synchronized (object) {
            Schedule.PointEvent[] pointEvents = (Schedule.PointEvent[])this.toArray(new Schedule.PointEvent[this.size()]);
            DateTime startStamp = DateTime.now();
            this.clear();
            for (Schedule.PointEvent pointEvent : pointEvents) {
                this.add((Schedule.Event)new Schedule.PointEvent(pointEvent.getPoint(), startStamp, sync.copy()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerNow() {
        Object object = this.getMutex();
        synchronized (object) {
            this._allDue = true;
            this.cancelWait();
        }
    }
}

