/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.server.pap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Point;
import org.rvpf.base.Points;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.security.Identity;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPClient;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPSupport;
import org.rvpf.store.server.StoreMessages;
import org.rvpf.store.server.StoreServer;
import org.rvpf.store.server.StoreServiceAppImpl;
import org.rvpf.store.server.archiver.Archiver;

public final class PAPStoreServer
extends StoreServer.Abstract {
    public static final String TRACES_PROPERTY = "traces";
    private static final StoreValues _RESPONSE_MARKER = new StoreValues();
    private PAPClient _client;
    private final PAPSupport _protocolSupport;
    private final Traces _traces = new Traces();

    public PAPStoreServer(@Nonnull PAPSupport protocolSupport) {
        this._protocolSupport = protocolSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public boolean acceptMetadata(@Nonnull Metadata metadata) {
        PAPContext context = this._protocolSupport.newClientContext(metadata, Optional.empty());
        if (context == null) {
            return false;
        }
        PAPClient client = this._protocolSupport.newClient(context);
        this.lock();
        try {
            if (this._client != null) {
                this._client.close();
            }
            this._client = client;
            this._client.open();
        }
        finally {
            this.unlock();
        }
        return true;
    }

    public Optional<Archiver> newArchiver() {
        return Optional.empty();
    }

    public StoreValues[] select(StoreValuesQuery[] queries, Optional<Identity> identity) throws SessionException {
        this.activateServiceClassLoader();
        StoreValues[] responses = new StoreValues[queries.length];
        PAPClient client = this._client;
        this.lock();
        try {
            if (client == null) {
                throw new ServiceClosedException();
            }
            long mark = System.nanoTime();
            ArrayList points = new ArrayList(queries.length);
            for (int i = 0; i < queries.length; ++i) {
                StoreValuesQuery query = queries[i];
                if (query == null) {
                    responses[i] = null;
                    continue;
                }
                StoreValuesQuery.Builder queryBuilder = StoreValuesQuery.newBuilder().copyFrom(query);
                if (!queryBuilder.restore((Points)this.getMetadata())) {
                    this.getThisLogger().trace((Messages.Entry)StoreMessages.QUERY_RECEIVED, new Object[]{query});
                    responses[i] = this.unknownQueryPoint(query);
                    continue;
                }
                query = queryBuilder.build();
                this.getThisLogger().trace((Messages.Entry)StoreMessages.QUERY_RECEIVED, new Object[]{query});
                queries[i] = query;
                if (query.isPull()) {
                    responses[i] = this.unsupportedPullQuery();
                    continue;
                }
                points.add(query.getPoint().get());
                responses[i] = _RESPONSE_MARKER;
            }
            List<PointValue> pointValues = Arrays.asList(client.fetchPointValues(points.toArray(new Point[points.size()])));
            Iterator pointValuesIterator = pointValues.iterator();
            for (int i = 0; i < queries.length; ++i) {
                if (responses[i] != _RESPONSE_MARKER) continue;
                PointValue pointValue = (PointValue)pointValuesIterator.next();
                StoreValuesQuery query = queries[i];
                StoreValues storeValues = new StoreValues(query);
                if (pointValue != null) {
                    storeValues.add(pointValue);
                    this.getThisLogger().trace((Messages.Entry)StoreMessages.QUERY_ANSWER, new Object[]{query.isCount() ? "1" : pointValue});
                } else if (query.isCount()) {
                    this.getThisLogger().trace((Messages.Entry)StoreMessages.QUERY_ANSWER, new Object[]{"0"});
                }
                responses[i] = storeValues;
                this.getThisLogger().trace((Messages.Entry)StoreMessages.QUERY_DONE, new Object[0]);
                this.getStats().addQueryResponse(Optional.of(responses[i]), 0L);
            }
            this.getStats().addQueryResponse(Optional.empty(), System.nanoTime() - mark);
        }
        catch (RuntimeException exception) {
            this.getThisLogger().warn((Throwable)exception, (Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
            throw exception;
        }
        catch (InterruptedException exception) {
            throw new SessionException((Exception)exception);
        }
        catch (ServiceNotAvailableException exception) {
            throw new SessionException((Exception)((Object)exception));
        }
        catch (Exception exception) {
            this.getThisLogger().trace((Throwable)exception, (Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
            throw exception;
        }
        finally {
            this.unlock();
        }
        this.getThisLogger().trace((Messages.Entry)StoreMessages.QUERIES_DONE, new Object[0]);
        return responses;
    }

    public boolean setUp(StoreServiceAppImpl storeAppImpl) {
        if (!super.setUp(storeAppImpl)) {
            return false;
        }
        return this._traces.setUp(storeAppImpl.getDataDir(), storeAppImpl.getConfigProperties().getGroup(TRACES_PROPERTY), storeAppImpl.getSourceUUID(), storeAppImpl.getServerProperties().getString(TRACES_PROPERTY));
    }

    public void stop() {
        this.lock();
        try {
            if (this._client != null) {
                this._client.close();
                this._client = null;
            }
            this._traces.tearDown();
        }
        finally {
            this.unlock();
        }
        super.stop();
    }

    public String supportedValueTypeCodes() throws SessionException {
        return this._protocolSupport.supportedValueTypeCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception[] update(PointValue[] pointValues, Optional<Identity> identity) throws SessionException {
        this.activateServiceClassLoader();
        Exception[] exceptions = this.restoreUpdates(pointValues);
        PAPClient client = this._client;
        this.lock();
        try {
            if (client == null) {
                throw new ServiceClosedException();
            }
            long mark = System.nanoTime();
            ArrayList<PointValue> updates = new ArrayList<PointValue>(pointValues.length);
            long ignored = 0L;
            long updated = 0L;
            for (int i = 0; i < pointValues.length; ++i) {
                if (exceptions[i] != null) {
                    ++ignored;
                    continue;
                }
                PointValue pointValue = pointValues[i];
                Exception exception = exceptions[i] = pointValue.isDeleted() ? new UnsupportedOperationException() : (Exception)this.checkUpdate(pointValue, identity).orElse(null);
                if (exceptions[i] != null) {
                    ++ignored;
                    continue;
                }
                updates.add(pointValue);
            }
            try {
                Exception[] responses = this._client.updatePointValues(updates.toArray(new PointValue[updates.size()]));
                Iterator<Exception> responsesIterator = Arrays.asList(responses).iterator();
                for (int i = 0; i < pointValues.length; ++i) {
                    if (exceptions[i] != null) continue;
                    exceptions[i] = responsesIterator.next();
                    if (exceptions[i] != null) continue;
                    PointValue pointValue = pointValues[i];
                    ++updated;
                    this.getUpdatedTraces().add((Object)pointValue);
                    this.getThisLogger().trace((Messages.Entry)StoreMessages.UPDATER_UPDATED, new Object[]{pointValue});
                    this.getReplicator().replicate(pointValue);
                    this.addNotice(pointValue);
                }
                this.getReplicator().commit();
                this.sendNotices();
            }
            catch (InterruptedException exception) {
                throw new SessionException((Exception)exception);
            }
            catch (ConnectFailedException exception) {
                throw new SessionException((Exception)((Object)exception));
            }
            catch (RuntimeException exception) {
                this.getThisLogger().warn((Throwable)exception, (Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
                throw exception;
            }
            catch (Exception exception) {
                this.getThisLogger().trace((Throwable)exception, (Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
                throw new RuntimeException(exception);
            }
            this.reportUpdates(updated, 0L, ignored, System.nanoTime() - mark);
        }
        finally {
            this.unlock();
        }
        return exceptions;
    }

    protected boolean supportsUpdateTracer() {
        return true;
    }
}

