/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.server.pap;

import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPSupport;
import org.rvpf.store.server.StoreServer;
import org.rvpf.store.server.StoreServiceAppImpl;
import org.rvpf.store.server.pap.PAPStoreServer;

public final class PAPStoreServiceAppImpl
extends StoreServiceAppImpl {
    public static final String PROTOCOL_PROPERTY = "protocol";
    public static final String SERVER_PROPERTIES = "store.server.pap";
    private PAPStoreServer _server;

    public PAPStoreServer getServer() {
        return (PAPStoreServer)((Object)Require.notNull((Object)((Object)this._server)));
    }

    public boolean onNewMetadata(Metadata metadata) {
        if (!super.onNewMetadata(metadata)) {
            return false;
        }
        return this._server == null || this._server.acceptMetadata(metadata);
    }

    public void tearDown() {
        this.stop();
        if (this._server != null) {
            this._server.tearDown();
            this._server = null;
        }
        super.tearDown();
    }

    protected boolean refreshMetadata() {
        if (!this.getService().reloadMetadata()) {
            return false;
        }
        this.refreshNoticesFilter();
        return true;
    }

    protected boolean setUp() {
        if (!super.setUp(SERVER_PROPERTIES)) {
            return false;
        }
        if (this.isNullRemoves()) {
            this.getThisLogger().error((Messages.Entry)PAPMessages.REMOVES_NOT_ALLOWED, new Object[0]);
            return false;
        }
        Optional protocol = this.getServerProperties().getString(PROTOCOL_PROPERTY);
        if (!protocol.isPresent()) {
            this.getThisLogger().error((Messages.Entry)BaseMessages.MISSING_PROPERTY_IN, new Object[]{PROTOCOL_PROPERTY, SERVER_PROPERTIES});
        }
        PAPSupport protocolSupport = null;
        for (PAPSupport support : PAPSupport.getProtocolSupports((KeyedValues)this.getConfigProperties())) {
            if (!((String)protocol.get()).equalsIgnoreCase(support.getProtocolName())) continue;
            protocolSupport = support;
        }
        if (protocolSupport == null) {
            this.getThisLogger().error((Messages.Entry)PAPMessages.UNKNOWN_PROTOCOL, new Object[]{protocol.get()});
            return false;
        }
        this._server = new PAPStoreServer(protocolSupport);
        if (!this.setUpNotifier()) {
            return false;
        }
        if (!this._server.setUp(this)) {
            return false;
        }
        if (!this._server.acceptMetadata(this.getMetadata())) {
            return false;
        }
        return this.registerServer((StoreServer)this._server);
    }
}

