/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.server.pap;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPProxy;
import org.rvpf.store.server.StoreServiceAppImpl;
import org.rvpf.store.server.UpdatesListener;

public abstract class PAPUpdatesListener
extends UpdatesListener.Abstract
implements PAPProxy.Responder {
    public static final String TRACES_PROPERTY = "traces";
    private final Traces _traces = new Traces();

    @Override
    public PointValue[] select(Point[] points) throws InterruptedException, ServiceNotAvailableException {
        StoreValuesQuery[] storeQueries = new StoreValuesQuery[points.length];
        StoreValuesQuery.Builder storeQueryBuilder = StoreValuesQuery.newBuilder();
        for (int i = 0; i < points.length; ++i) {
            storeQueries[i] = storeQueryBuilder.setPoint(points[i]).build();
        }
        StoreValues[] response = this.getServer().select(storeQueries, Optional.empty());
        PointValue[] pointValues = new PointValue[response.length];
        Require.equal((long)storeQueries.length, (long)response.length);
        for (int i = 0; i < response.length; ++i) {
            pointValues[i] = response[i].getPointValue().orElse(null);
        }
        return pointValues;
    }

    public boolean setUp(StoreServiceAppImpl storeAppImpl, KeyedGroups listenerProperties) {
        if (!super.setUp(storeAppImpl, listenerProperties)) {
            return false;
        }
        return this._traces.setUp(storeAppImpl.getDataDir(), storeAppImpl.getConfigProperties().getGroup(TRACES_PROPERTY), storeAppImpl.getSourceUUID(), listenerProperties.getString(TRACES_PROPERTY));
    }

    @Nonnull
    @CheckReturnValue
    protected Traces getTraces() {
        return this._traces;
    }
}

