/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tool;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;

public final class Home {
    private static final String _HOME_KEY = "home";

    private Home() {
    }

    public static void main(@Nonnull String[] args) {
        if (args.length > 1) {
            String actionName = args[0];
            String nodePath = args[1].replace('\\', '/');
            if ("get".equals(actionName) && args.length <= 3) {
                Home._doGetHome(nodePath, args.length > 2 ? args[2] : "");
            } else if ("set".equals(actionName) && args.length == 3) {
                Home._doSetHome(nodePath, args[2]);
            } else {
                Home._usage();
            }
        } else {
            Home._usage();
        }
    }

    private static void _doGetHome(String nodePath, String prefix) {
        String home;
        Preferences userRoot = Preferences.userRoot();
        try {
            home = userRoot.nodeExists(nodePath) ? userRoot.node(nodePath).get(_HOME_KEY, "") : "";
        }
        catch (BackingStoreException exception) {
            throw new RuntimeException(exception);
        }
        System.out.print(prefix + home);
    }

    private static void _doSetHome(String nodePath, String directoryPath) {
        Preferences applicationNode = Preferences.userRoot().node(nodePath);
        File file = new File(directoryPath);
        if (!file.isDirectory()) {
            Home._usage();
        }
        applicationNode.put(_HOME_KEY, file.getAbsolutePath());
    }

    private static void _usage() {
        System.out.println("Usages:");
        System.out.println("         set <application-node> <application-directory>");
        System.out.println("         get <aplication-node> [<output-prefix>]");
        System.exit(1);
    }
}

