/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip;

import java.nio.channels.AsynchronousCloseException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPClient;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.cip.CIPClientContext;
import org.rvpf.pap.cip.CIPServerProxy;
import org.rvpf.pap.cip.transport.ReadTransaction;
import org.rvpf.pap.cip.transport.WriteTransaction;

public class CIPClient
extends PAPClient.Abstract {
    private final Set<CIPServerProxy> _inputServerProxies = new IdentityHashSet();
    private final Set<CIPServerProxy> _outputServerProxies = new IdentityHashSet();

    public CIPClient(@Nonnull CIPClientContext clientContext) {
        super(clientContext);
    }

    @Override
    public void close() {
        this.disconnect();
        this.rollbackReadRequests();
        this.rollbackWriteRequests();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public Collection<WriteTransaction.Response> commitPointUpdateRequests() throws ServiceNotAvailableException {
        LinkedList<WriteTransaction.Response> responses = new LinkedList<WriteTransaction.Response>();
        Set<CIPServerProxy> set = this._outputServerProxies;
        synchronized (set) {
            for (CIPServerProxy serverProxy : this._outputServerProxies) {
                try {
                    for (WriteTransaction.Response response : serverProxy.commitWriteRequests()) {
                        responses.add(response);
                    }
                }
                catch (ServiceNotAvailableException exception) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.WRITE_COMMIT_FAILED, new Object[]{serverProxy.getName().orElse(null)});
                    throw exception;
                }
            }
            this._outputServerProxies.clear();
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public Collection<ReadTransaction.Response> commitPointValueRequests() throws ServiceNotAvailableException {
        LinkedList<ReadTransaction.Response> responses = new LinkedList<ReadTransaction.Response>();
        Set<CIPServerProxy> set = this._inputServerProxies;
        synchronized (set) {
            for (CIPServerProxy serverProxy : this._inputServerProxies) {
                try {
                    for (ReadTransaction.Response response : serverProxy.commitReadRequests()) {
                        responses.add(response);
                    }
                }
                catch (ConnectFailedException exception) {
                    throw exception;
                }
                catch (ServiceNotAvailableException exception) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.READ_COMMIT_FAILED, new Object[]{serverProxy.getName().orElse(null)});
                    throw exception;
                }
            }
            this._inputServerProxies.clear();
        }
        return responses;
    }

    @Override
    public boolean connect(Origin origin) {
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy(origin);
        if (!serverProxy.isPresent()) {
            return false;
        }
        ((CIPClientContext)this.getContext()).setConnectionListener(this);
        try {
            ((CIPServerProxy)serverProxy.get()).connect();
        }
        catch (ConnectFailedException exception) {
            return false;
        }
        return true;
    }

    @Override
    public void disconnect(Origin origin) {
        Optional<PAPProxy> serverProxy = this.forgetServerProxy(origin);
        if (serverProxy.isPresent()) {
            serverProxy.get().disconnect();
        }
    }

    @Override
    public PointValue[] fetchPointValues(Point[] points) throws InterruptedException, ServiceNotAvailableException {
        Collection<ReadTransaction.Response> responses;
        for (Point point : points) {
            Optional<ReadTransaction.Request> request = this.requestPointValue(point);
            Require.success((boolean)request.isPresent());
        }
        try {
            responses = this.commitPointValueRequests();
        }
        catch (ServiceNotAvailableException exception) {
            if (exception.getCause() instanceof AsynchronousCloseException) {
                throw new InterruptedException();
            }
            throw exception;
        }
        PointValue[] pointValues = new PointValue[points.length];
        Iterator<ReadTransaction.Response> responsesIterator = responses.iterator();
        for (int i = 0; i < pointValues.length; ++i) {
            ReadTransaction.Response response = responsesIterator.next();
            pointValues[i] = response.isSuccess() ? response.getPointValue().get() : null;
        }
        return pointValues;
    }

    @Override
    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public Optional<WriteTransaction.Request> requestPointUpdate(@Nonnull PointValue pointValue) {
        Point point = (Point)pointValue.getPoint().get();
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy((Origin)point.getOrigin().get());
        if (!serverProxy.isPresent()) {
            return Optional.empty();
        }
        Set<CIPServerProxy> set = this._outputServerProxies;
        synchronized (set) {
            this._outputServerProxies.add((CIPServerProxy)serverProxy.get());
        }
        return Optional.of(((CIPServerProxy)serverProxy.get()).addWriteRequest(pointValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public Optional<ReadTransaction.Request> requestPointValue(@Nonnull Point point) {
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy((Origin)point.getOrigin().get());
        if (!serverProxy.isPresent()) {
            return Optional.empty();
        }
        Set<CIPServerProxy> set = this._inputServerProxies;
        synchronized (set) {
            this._inputServerProxies.add((CIPServerProxy)serverProxy.get());
        }
        return Optional.of(((CIPServerProxy)serverProxy.get()).addReadRequest(point));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackReadRequests() {
        Set<CIPServerProxy> set = this._inputServerProxies;
        synchronized (set) {
            for (CIPServerProxy serverProxy : this._inputServerProxies) {
                serverProxy.rollbackReadRequests();
            }
            this._inputServerProxies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackWriteRequests() {
        Set<CIPServerProxy> set = this._outputServerProxies;
        synchronized (set) {
            for (CIPServerProxy serverProxy : this._outputServerProxies) {
                serverProxy.rollbackWriteRequests();
            }
            this._outputServerProxies.clear();
        }
    }

    @Override
    public Exception[] updatePointValues(PointValue[] pointValues) throws ServiceNotAvailableException {
        Exception[] exceptions = new Exception[pointValues.length];
        IdentityHashMap<WriteTransaction.Request, Integer> requests = new IdentityHashMap<WriteTransaction.Request, Integer>();
        for (int i = 0; i < pointValues.length; ++i) {
            Optional<WriteTransaction.Request> request = this.requestPointUpdate(pointValues[i]);
            if (request.isPresent()) {
                requests.put(request.get(), i);
                continue;
            }
            exceptions[i] = new ServiceNotAvailableException();
        }
        for (WriteTransaction.Response response : this.commitPointUpdateRequests()) {
            int i = (Integer)requests.get(response.getRequest());
            if (response.isSuccess()) continue;
            exceptions[i] = new Exception();
        }
        return exceptions;
    }
}

