/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.cip.CIPContext;
import org.rvpf.pap.cip.CIPProxy;
import org.rvpf.pap.cip.CIPServerProxy;

public final class CIPClientContext
extends CIPContext {
    private final Set<String> _remoteOrigins = new HashSet<String>();

    CIPClientContext(@Nonnull Metadata metadata, @Nonnull Optional<Traces> traces) {
        super(Optional.of(metadata), traces);
    }

    @Override
    public boolean addRemotePoint(Point remotePoint, Attributes pointAttributes) {
        if (pointAttributes.getBoolean("CONNECTION_STATE")) {
            Optional<? extends PAPProxy> remoteProxy = this.getRemoteProxy(remotePoint);
            if (!remoteProxy.isPresent()) {
                return false;
            }
            if (!remoteProxy.get().setConnectionStatePoint(remotePoint)) {
                return false;
            }
            this.registerRemotePoint(remotePoint);
            return true;
        }
        return super.addRemotePoint(remotePoint, pointAttributes);
    }

    @Override
    public String getProtocolName() {
        return "CIP";
    }

    @Override
    public boolean isClientContext() {
        return true;
    }

    @Override
    protected int getDefaultPortForRemoteOrigin() {
        return 44818;
    }

    @Override
    protected boolean isRemoteOriginNeeded(Origin remoteOrigin, Attributes originAttributes) {
        String socketAddressString = (String)originAttributes.getString("TCP_ADDRESS").get();
        if (socketAddressString.isEmpty()) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"TCP_ADDRESS", "CIP", remoteOrigin});
            return false;
        }
        return this._remoteOrigins.add((String)remoteOrigin.getNameInUpperCase().get());
    }

    @Override
    protected boolean isRemotePointNeeded(Point remotePoint, Attributes pointAttributes) {
        Optional remoteOrigin = remotePoint.getOrigin();
        return remoteOrigin.isPresent() && this._remoteOrigins.contains(((Origin)remoteOrigin.get()).getNameInUpperCase().get());
    }

    @Override
    protected CIPProxy newRemoteProxy(Origin remoteOrigin) {
        return new CIPServerProxy(this, remoteOrigin);
    }

    void setConnectionListener(@Nonnull PAPConnectionListener connectionListener) {
        for (PAPProxy pAPProxy : this.getRemoteProxies()) {
            ((CIPServerProxy)pAPProxy).setConnectionListener(connectionListener);
        }
    }
}

