/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip;

import java.net.InetSocketAddress;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.cip.CIP;
import org.rvpf.pap.cip.CIPContext;
import org.rvpf.pap.cip.CIPMessages;
import org.rvpf.pap.cip.CIPProxy;
import org.rvpf.pap.cip.transport.ClientConnection;
import org.rvpf.pap.cip.transport.ReadTransaction;
import org.rvpf.pap.cip.transport.WriteTransaction;

public class CIPServerProxy
extends CIPProxy {
    private final Object _connectMutex = new Object();
    private ClientConnection _connection;
    private final ReadTransaction _readTransaction = new ReadTransaction(this);
    private int _slot;
    private long _timeout;
    private final WriteTransaction _writeTransaction = new WriteTransaction(this);

    CIPServerProxy(@Nonnull CIPContext context, @Nonnull Origin origin) {
        super(context, origin);
    }

    private CIPServerProxy(CIPServerProxy other) {
        super(other);
        this._slot = other._slot;
        this._timeout = other._timeout;
    }

    @Nonnull
    @CheckReturnValue
    public ReadTransaction.Request addReadRequest(@Nonnull Point point) {
        return this._readTransaction.addRequest(point);
    }

    @Nonnull
    @CheckReturnValue
    public WriteTransaction.Request addWriteRequest(@Nonnull PointValue pointValue) {
        return this._writeTransaction.addRequest(pointValue);
    }

    @Nonnull
    @CheckReturnValue
    public ReadTransaction.Response[] commitReadRequests() throws ServiceNotAvailableException {
        try {
            return this._readTransaction.commit();
        }
        catch (ServiceNotAvailableException exception) {
            this.disconnect();
            throw exception;
        }
    }

    @Nonnull
    @CheckReturnValue
    public WriteTransaction.Response[] commitWriteRequests() throws ServiceNotAvailableException {
        try {
            return this._writeTransaction.commit();
        }
        catch (ServiceNotAvailableException exception) {
            this.disconnect();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public ClientConnection connect() throws ConnectFailedException {
        Object object = this._connectMutex;
        synchronized (object) {
            if (this._connection == null) {
                ClientConnection connection = new ClientConnection(this.getTcpAddress(), this.getTcpPort(), this._slot, this._timeout, this, this.getConnectionListener());
                try {
                    connection.open();
                }
                catch (ConnectFailedException exception) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.SERVER_CONNECTION_FAILED, new Object[]{new InetSocketAddress(this.getTcpAddress(), this.getTcpPort())});
                    throw exception;
                }
                this._connection = connection;
            }
        }
        return this._connection;
    }

    @Override
    public PAPProxy copy() {
        return new CIPServerProxy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this._connectMutex;
        synchronized (object) {
            ClientConnection connection = this._connection;
            if (connection != null) {
                this._connection = null;
                connection.close();
                super.disconnect();
            }
        }
    }

    public void rollbackReadRequests() {
        this._readTransaction.rollback();
    }

    public void rollbackWriteRequests() {
        this._writeTransaction.rollback();
    }

    @Override
    protected boolean setUp(Attributes originAttributes) {
        if (!super.setUp(originAttributes)) {
            return false;
        }
        this._slot = originAttributes.getInt("SLOT", 0);
        this.getThisLogger().debug((Messages.Entry)CIPMessages.SLOT, new Object[]{String.valueOf(this._slot)});
        ElapsedTime timeout = (ElapsedTime)originAttributes.getElapsed("TIMEOUT", Optional.of(CIP.DEFAULT_TIMEOUT), Optional.of(ElapsedTime.INFINITY)).get();
        this.getThisLogger().debug((Messages.Entry)CIPMessages.TIMEOUT, new Object[]{timeout});
        this._timeout = timeout.toMillis();
        return true;
    }
}

