/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip.transport;

import etherip.types.CIPData;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.pap.PAPConnection;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.cip.CIPMessages;
import org.rvpf.pap.cip.CIPProxy;
import org.rvpf.pap.cip.transport.EtherIPWrapper;
import org.rvpf.pap.cip.transport.EthernetIPWrapper;
import org.rvpf.pap.cip.transport.ReadTransaction;
import org.rvpf.pap.cip.transport.WriteTransaction;

public final class ClientConnection
extends PAPConnection.Abstract {
    private final EthernetIPWrapper _ethernetIP;
    private volatile Exception _exception;
    private final PAPConnectionListener _listener;
    private final CIPProxy _remoteProxy;
    private final Map<String, CIPData.Type> _typesByTag = new HashMap<String, CIPData.Type>();

    public ClientConnection(@Nonnull String address, int port, int slot, long timeout, @Nonnull CIPProxy remoteProxy, @Nonnull PAPConnectionListener listener) {
        this._ethernetIP = EtherIPWrapper.newBuilder().setAddress(address).setPort(port).setSlot(slot).setTimeout(timeout).build();
        this._remoteProxy = remoteProxy;
        this._listener = listener;
    }

    @Override
    public void doClose() throws IOException {
        if (this._ethernetIP.isConnected()) {
            try {
                this._ethernetIP.close();
            }
            catch (IOException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
            Require.ignored((boolean)this._listener.onLostConnection(this._remoteProxy, Optional.ofNullable(this._exception)));
        }
    }

    public void open() throws ConnectFailedException {
        if (!this._ethernetIP.isConnected()) {
            try {
                this._ethernetIP.connect();
            }
            catch (Exception connectException) {
                try {
                    this._ethernetIP.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ConnectFailedException((Messages.Entry)CIPMessages.CONNECT_FAILED, new Object[]{this._ethernetIP.getAddress(), connectException.getMessage()});
            }
            Require.ignored((boolean)this._listener.onNewConnection(this._remoteProxy));
        }
    }

    public void sendReadRequests(@Nonnull ReadTransaction transaction) throws ServiceNotAvailableException {
        if (transaction.isEmpty()) {
            return;
        }
        Collection<ReadTransaction.Request> requests = transaction.getRequests();
        String[] tags = new String[requests.size()];
        int[] elements = new int[tags.length];
        int index = 0;
        for (ReadTransaction.Request request : requests) {
            Point point = request.getPoint();
            Optional pointAttributes = point.getAttributes("CIP");
            tags[index] = this._remoteProxy.getContext().getTag(point);
            elements[index++] = pointAttributes.isPresent() ? ((Attributes)pointAttributes.get()).getInt("ELEMENTS", 1) : 1;
        }
        try {
            CIPData[] values = this._ethernetIP.readTags(tags, elements);
            DateTime now = DateTime.now();
            index = 0;
            for (ReadTransaction.Request request : requests) {
                Serializable value;
                String tag = tags[index];
                CIPData data = values[index];
                if (data == null) {
                    this.getThisLogger().warn((Messages.Entry)CIPMessages.READ_TAG_FAILED, new Object[]{tag, this._ethernetIP.decodeStatus(index)});
                    transaction.addResponse(request, Optional.empty());
                    continue;
                }
                int dataElements = elements[index++];
                if (data.getElementCount() != dataElements) {
                    this.getThisLogger().warn((Messages.Entry)CIPMessages.ELEMENT_COUNT_MISMATCH, new Object[]{tag});
                    transaction.addResponse(request, Optional.empty());
                    continue;
                }
                if (dataElements > 1) {
                    Tuple tuple = new Tuple(dataElements);
                    for (int element = 0; element < dataElements; ++element) {
                        tuple.add(ClientConnection._convert(data, element));
                    }
                    value = tuple;
                } else {
                    value = ClientConnection._convert(data, 0);
                }
                PointValue pointValue = new PointValue(request.getPoint(), Optional.of(now), null, value);
                transaction.addResponse(request, Optional.of(pointValue));
                if (this._typesByTag.containsKey(tag)) continue;
                this._typesByTag.put(tag, data.getType());
            }
        }
        catch (Exception exception) {
            this._exception = exception;
            this.close();
            throw new ServiceNotAvailableException(exception);
        }
    }

    public void sendWriteRequests(@Nonnull WriteTransaction transaction) throws ServiceNotAvailableException {
        CIPData[] pointValue;
        if (transaction.isEmpty()) {
            return;
        }
        Collection<WriteTransaction.Request> requests = transaction.getRequests();
        String[] tags = new String[requests.size()];
        CIPData[] values = new CIPData[tags.length];
        int[] elements = new int[tags.length];
        LinkedList<String> newTags = new LinkedList<String>();
        int index = 0;
        for (WriteTransaction.Request request : requests) {
            String tag;
            pointValue = request.getPointValue();
            Point point = (Point)pointValue.getPoint().get();
            Optional pointAttributes = point.getAttributes("CIP");
            tags[index] = tag = this._remoteProxy.getContext().getTag(point);
            if (!this._typesByTag.containsKey(tag)) {
                newTags.add(tag);
            }
            elements[index++] = pointAttributes.isPresent() ? ((Attributes)pointAttributes.get()).getInt("ELEMENTS", 1) : 1;
        }
        if (!newTags.isEmpty()) {
            CIPData[] dataArray;
            try {
                dataArray = this._ethernetIP.readTags(newTags.toArray(new String[newTags.size()]));
            }
            catch (Exception exception) {
                this._exception = exception;
                this.close();
                throw new ServiceNotAvailableException(exception);
            }
            Iterator iterator = newTags.iterator();
            for (CIPData data : dataArray) {
                String tag = (String)iterator.next();
                if (data == null) continue;
                this._typesByTag.put(tag, data.getType());
            }
        }
        index = 0;
        try {
            block6: for (WriteTransaction.Request request : requests) {
                pointValue = request.getPointValue();
                String tag = tags[index];
                int tagElements = elements[index];
                Serializable value = pointValue.getValue();
                CIPData.Type type = this._typesByTag.get(tag);
                if (type == null) {
                    transaction.addResponse(request, false);
                    continue;
                }
                CIPData data = new CIPData(type, tagElements);
                if (value instanceof Tuple) {
                    if (((Tuple)value).size() != tagElements) {
                        this.getThisLogger().warn((Messages.Entry)CIPMessages.TUPLE_SIZE_MISMATCH, new Object[]{tag});
                        transaction.addResponse(request, false);
                        continue;
                    }
                    int element = 0;
                    for (Serializable item : (Tuple)value) {
                        if (item instanceof Number) {
                            data.set(element++, (Number)item);
                            continue;
                        }
                        if (item instanceof Boolean) {
                            data.set(element++, (Number)((byte)((Boolean)item != false ? -1 : 0)));
                            continue;
                        }
                        this.getThisLogger().warn((Messages.Entry)CIPMessages.TUPLE_ITEMS, new Object[]{tag});
                        transaction.addResponse(request, false);
                        continue block6;
                    }
                } else {
                    if (tagElements > 1) {
                        this.getThisLogger().warn((Messages.Entry)CIPMessages.TUPLE_REQUIRED, new Object[]{tag});
                        transaction.addResponse(request, false);
                        continue;
                    }
                    if (value instanceof Number) {
                        data.set(0, (Number)value);
                    } else if (value instanceof Boolean) {
                        data.set(0, (Number)((byte)((Boolean)value != false ? -1 : 0)));
                    } else {
                        this.getThisLogger().warn((Messages.Entry)CIPMessages.VALUES_MUST_BE_NUMBER, new Object[]{tag});
                        transaction.addResponse(request, false);
                        continue;
                    }
                }
                values[index++] = data;
                transaction.addResponse(request, true);
            }
            this._ethernetIP.writeTags(tags, values);
        }
        catch (Exception exception) {
            transaction.setException(exception);
        }
        for (int i = 0; i < tags.length; ++i) {
            int status = this._ethernetIP.getStatus(i);
            if (status == 0) continue;
            this.getThisLogger().warn((Messages.Entry)CIPMessages.WRITE_TAG_FAILED, new Object[]{tags[i], this._ethernetIP.decodeStatus(i)});
        }
    }

    @Override
    protected String getName() {
        return this._ethernetIP.getAddress();
    }

    private static Serializable _convert(@Nonnull CIPData data, int element) throws Exception {
        Object value;
        if (data.isNumeric()) {
            Number number = data.getNumber(element);
            switch (data.getType()) {
                case BOOL: {
                    value = number.byteValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case USINT: {
                    value = (short)(number.byteValue() & 0xFF);
                    break;
                }
                case UINT: {
                    value = number.shortValue() & 0xFFFF;
                    break;
                }
                case UDINT: {
                    value = (long)number.intValue() & 0xFFFFFFFFL;
                    break;
                }
                default: {
                    value = number;
                    break;
                }
            }
        } else {
            try {
                value = data.getString();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return value;
    }
}

