/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip.transport;

import etherip.EtherNetIP;
import etherip.types.CIPData;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.cip.transport.EthernetIPWrapper;

public final class EtherIPWrapper
implements EthernetIPWrapper {
    private final String _address;
    private final EtherNetIP _etherNetIP;

    EtherIPWrapper(@Nonnull String address, int port, int slot, long timeout) {
        this._address = address;
        this._etherNetIP = new EtherNetIP(address, slot);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void close() throws Exception {
        this._etherNetIP.close();
    }

    @Override
    public void connect() throws Exception {
        this._etherNetIP.connectTcp();
    }

    @Override
    public String decodeStatus(int index) {
        return this._etherNetIP.decodeStatus(index);
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public int getStatus(int index) {
        return this._etherNetIP.getStatus(index);
    }

    @Override
    public boolean isConnected() {
        return this._etherNetIP.isConnected();
    }

    @Override
    public CIPData[] readTags(String ... tags) throws Exception {
        return this._etherNetIP.readTags(tags);
    }

    @Override
    public CIPData[] readTags(String[] tags, int[] counts) throws Exception {
        return this._etherNetIP.readTags(tags, counts);
    }

    @Override
    public void writeTags(String[] tags, CIPData[] values) throws Exception {
        this._etherNetIP.writeTags(tags, values);
    }

    public static final class Builder
    extends EthernetIPWrapper.Builder {
        Builder() {
        }

        @Override
        public EtherIPWrapper build() {
            return new EtherIPWrapper(this.getAddress(), this.getPort(), this.getSlot(), this.getTimeout().toMillis());
        }
    }
}

