/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip.transport;

import etherip.types.CIPData;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.cip.CIP;

public interface EthernetIPWrapper {
    public void close() throws Exception;

    public void connect() throws Exception;

    @Nonnull
    @CheckReturnValue
    public String decodeStatus(int var1);

    @CheckReturnValue
    @Nonnull
    public String getAddress();

    @CheckReturnValue
    public int getStatus(int var1);

    @CheckReturnValue
    public boolean isConnected();

    @Nonnull
    @CheckReturnValue
    public CIPData[] readTags(String ... var1) throws Exception;

    @Nonnull
    @CheckReturnValue
    public CIPData[] readTags(@Nonnull String[] var1, @Nonnull int[] var2) throws Exception;

    public void writeTags(@Nonnull String[] var1, @Nonnull CIPData[] var2) throws Exception;

    public static abstract class Builder {
        private String _address;
        private int _port = 44818;
        private int _slot;
        private ElapsedTime _timeout = CIP.DEFAULT_TIMEOUT;

        @Nonnull
        @CheckReturnValue
        public abstract EthernetIPWrapper build();

        @Nonnull
        public Builder setAddress(@Nonnull String address) {
            this._address = (String)Require.notNull((Object)address);
            return this;
        }

        @Nonnull
        public Builder setPort(int port) {
            this._port = port;
            return this;
        }

        @Nonnull
        public Builder setSlot(int slot) {
            this._slot = slot;
            return this;
        }

        @Nonnull
        public Builder setTimeout(@Nonnull ElapsedTime timeout) {
            this._timeout = (ElapsedTime)Require.notNull((Object)timeout);
            return this;
        }

        @Nonnull
        public Builder setTimeout(long timeout) {
            this._timeout = ElapsedTime.fromMillis((long)timeout);
            return this;
        }

        @Nonnull
        @CheckReturnValue
        protected String getAddress() {
            return (String)Require.notNull((Object)this._address);
        }

        @CheckReturnValue
        protected int getPort() {
            return this._port;
        }

        @CheckReturnValue
        protected int getSlot() {
            return this._slot;
        }

        @Nonnull
        @CheckReturnValue
        protected ElapsedTime getTimeout() {
            return this._timeout;
        }
    }
}

