/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.cip.transport;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPReadTransaction;
import org.rvpf.pap.cip.CIPServerProxy;
import org.rvpf.pap.cip.transport.ClientConnection;
import org.rvpf.pap.cip.transport.Transaction;

public final class ReadTransaction
extends Transaction {
    private final Collection<Request> _requests = new LinkedList<Request>();
    private final Collection<Response> _responses = new LinkedList<Response>();

    public ReadTransaction(@Nonnull CIPServerProxy serverProxy) {
        super(serverProxy);
    }

    @Nonnull
    @CheckReturnValue
    public Request addRequest(@Nonnull Point point) {
        Request request = new Request(point);
        this._requests.add(request);
        return request;
    }

    @Nonnull
    @CheckReturnValue
    public Response[] commit() throws ServiceNotAvailableException {
        try {
            if (!this._requests.isEmpty()) {
                ClientConnection connection = this.getServerProxy().connect();
                connection.sendReadRequests(this);
            }
            Response[] responseArray = this._responses.toArray(new Response[this._responses.size()]);
            return responseArray;
        }
        finally {
            this.rollback();
        }
    }

    public void rollback() {
        this._requests.clear();
        this._responses.clear();
    }

    void addResponse(@Nonnull Request request, @Nonnull Optional<PointValue> pointValue) {
        this._responses.add(new Response(request, pointValue));
    }

    @Nonnull
    @CheckReturnValue
    Collection<Request> getRequests() {
        return this._requests;
    }

    @CheckReturnValue
    boolean isEmpty() {
        return this._requests.isEmpty();
    }

    public final class Response
    extends Transaction.Response
    implements PAPReadTransaction.Response {
        final Optional<PointValue> _pointValue;

        Response(@Nonnull Request request, Optional<PointValue> pointValue) {
            super(request);
            this._pointValue = pointValue;
        }

        @Override
        public Optional<PointValue> getPointValue() {
            return this._pointValue;
        }

        @Override
        public boolean isSuccess() {
            return this._pointValue != null && !ReadTransaction.this.getException().isPresent();
        }
    }

    public final class Request
    extends Transaction.Request
    implements PAPReadTransaction.Request {
        private final Point _point;

        Request(Point point) {
            super(ReadTransaction.this);
            this._point = (Point)Require.notNull((Object)point);
        }

        @Override
        public Point getPoint() {
            return this._point;
        }

        public Optional<Response> getResponse() throws InterruptedException {
            return Optional.empty();
        }

        @Override
        public boolean waitForResponse() throws InterruptedException {
            return false;
        }
    }
}

