/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input.pap.modbus;

import java.util.Optional;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.input.pap.PAPModule;
import org.rvpf.pap.PAPServer;
import org.rvpf.pap.modbus.ModbusSupport;

public final class ModbusModule
extends PAPModule {
    private static final Optional<ElapsedTime> _DEFAULT_BATCH_WAIT = Optional.of(ElapsedTime.fromRaw((long)(1L * ElapsedTime.MINUTE.toRaw())));

    protected Optional<ElapsedTime> getDefaultBatchWait() {
        return _DEFAULT_BATCH_WAIT;
    }

    @Override
    protected PAPModule.PAPInput newInput(PAPServer server) {
        return new _ModbusInput(server);
    }

    @Override
    protected ModbusSupport newSupport() {
        return new ModbusSupport();
    }

    @Override
    protected KeyedGroups protocolProperties(KeyedGroups moduleProperties) {
        return moduleProperties.getGroup("modbus");
    }

    @Override
    protected String usage() {
        return "MODBUS";
    }

    private final class _ModbusInput
    extends PAPModule.PAPInput {
        _ModbusInput(PAPServer server) {
            super(ModbusModule.this, server);
        }

        public String getDisplayName() {
            return "Modbus input";
        }

        public String getSourceName() {
            return "Modbus";
        }
    }
}

