/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPClient;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.PAPTransaction;
import org.rvpf.pap.modbus.ModbusClientContext;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusServerProxy;
import org.rvpf.pap.modbus.message.MaskWriteRegister;
import org.rvpf.pap.modbus.message.ReadCoils;
import org.rvpf.pap.modbus.message.ReadDiscreteInputs;
import org.rvpf.pap.modbus.message.ReadHoldingRegisters;
import org.rvpf.pap.modbus.message.ReadInputRegisters;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.message.WriteMultipleCoils;
import org.rvpf.pap.modbus.message.WriteMultipleRegisters;
import org.rvpf.pap.modbus.message.WriteReadMultipleRegisters;
import org.rvpf.pap.modbus.message.WriteSingleCoil;
import org.rvpf.pap.modbus.message.WriteSingleRegister;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.Register;

public final class ModbusClient
extends PAPClient.Abstract {
    public ModbusClient(@Nonnull ModbusClientContext clientContext) {
        super(clientContext);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime dateTime(@Nonnull short[] words) {
        ZonedDateTime zonedDateTime = ZonedDateTime.of((words[0] >> 8) + 2000, words[0] & 0xFF, words[1] >> 8, words[1] & 0xFF, 0, 0, 0, DateTime.getZoneId());
        return DateTime.fromZonedDateTime((ZonedDateTime)zonedDateTime).after((long)words[2] * ElapsedTime.SECOND.toRaw()).after((long)words[3] * (ElapsedTime.MILLI.toRaw() / 10L));
    }

    @CheckReturnValue
    public static short stamp0(@Nonnull DateTime stamp) {
        return (short)(stamp.scaled(ElapsedTime.SECOND) % 3600.0);
    }

    @CheckReturnValue
    public static short stamp1(@Nonnull DateTime stamp) {
        return (short)(stamp.scaled(ElapsedTime.MILLI.toRaw() / 10L) % 10000.0);
    }

    @Nonnull
    @CheckReturnValue
    public Collection<Transaction.Request> clearCompletedRequests(@Nonnull Origin origin) {
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy(origin);
        return serverProxy.isPresent() ? ((ModbusServerProxy)serverProxy.get()).clearCompletedRequests() : Collections.emptyList();
    }

    @Override
    public void close() {
        this.disconnect();
        super.close();
    }

    @Override
    public boolean connect(Origin origin) {
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy(origin);
        if (!serverProxy.isPresent()) {
            return false;
        }
        return ((ModbusServerProxy)serverProxy.get()).connect(true).isPresent();
    }

    @Override
    public void disconnect(Origin origin) {
        Optional<PAPProxy> serverProxy = this.forgetServerProxy(origin);
        if (serverProxy.isPresent()) {
            serverProxy.get().disconnect();
        }
    }

    @Override
    public PointValue[] fetchPointValues(Point[] points) throws InterruptedException, ServiceNotAvailableException {
        ReadTransaction.Request[] requests = new ReadTransaction.Request[points.length];
        int i = 0;
        for (Point point : points) {
            requests[i++] = this.requestPointValue(point).get();
        }
        if (!this.waitForResponses()) {
            throw new ServiceNotAvailableException();
        }
        PointValue[] pointValues = new PointValue[points.length];
        for (i = 0; i < pointValues.length; ++i) {
            ReadTransaction.Request request = requests[i];
            Optional<? extends PAPTransaction.Response> response = request.getResponse();
            if (!response.isPresent()) {
                throw new ServiceNotAvailableException();
            }
            pointValues[i] = response.get().isSuccess() ? ((ReadTransaction.Response)response.get()).getPointValue().get() : null;
        }
        return pointValues;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> maskWriteRegister(@Nonnull Origin serverOrigin, int registerAddress, int andMask, int orMask) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new MaskWriteRegister.Request(registerAddress, andMask, orMask));
    }

    @Override
    public void open() {
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> readCoils(@Nonnull Origin serverOrigin, int startingAddress, int quantityOfCoils) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new ReadCoils.Request(startingAddress, quantityOfCoils));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> readDiscreteInputs(@Nonnull Origin serverOrigin, int startingAddress, int quantityOfInputs) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new ReadDiscreteInputs.Request(startingAddress, quantityOfInputs));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> readHoldingRegisters(@Nonnull Origin serverOrigin, int startingAddress, int quantityOfRegisters) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new ReadHoldingRegisters.Request(startingAddress, quantityOfRegisters));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> readInputRegisters(@Nonnull Origin serverOrigin, int startingAddress, int quantityOfInputs) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new ReadInputRegisters.Request(startingAddress, quantityOfInputs));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<ReadTransaction.Request> requestPointValue(@Nonnull Point point) throws ConnectFailedException {
        Optional register;
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy((Origin)point.getOrigin().get());
        Optional<Object> optional = register = serverProxy.isPresent() ? ((ModbusServerProxy)serverProxy.get()).getRegister(point) : Optional.empty();
        if (!register.isPresent()) {
            return Optional.empty();
        }
        ReadTransaction.Request request = ((Register)register.get()).createReadRequest();
        request.setPoint(point);
        return Optional.ofNullable((ReadTransaction.Request)((ModbusServerProxy)serverProxy.get()).sendRequest(request));
    }

    @Override
    public Exception[] updatePointValues(PointValue[] pointValues) throws ConnectFailedException, InterruptedException {
        int i;
        Exception[] exceptions = new Exception[pointValues.length];
        Transaction.Request[] requests = new Transaction.Request[pointValues.length];
        for (i = 0; i < pointValues.length; ++i) {
            try {
                requests[i] = this.writePointValue(pointValues[i]).orElse(null);
            }
            catch (ConnectFailedException exception) {
                exceptions[i] = new ServiceNotAvailableException((Exception)((Object)exception));
                continue;
            }
            if (requests[i] != null) continue;
            exceptions[i] = new ServiceNotAvailableException();
        }
        for (i = 0; i < pointValues.length; ++i) {
            Optional<? extends PAPTransaction.Response> response;
            Transaction.Request request = requests[i];
            if (request == null || (response = request.getResponse()).isPresent() && response.get().isSuccess()) continue;
            exceptions[i] = new Exception();
        }
        return exceptions;
    }

    @CheckReturnValue
    public boolean waitForResponse(@Nonnull Origin origin) throws InterruptedException, ConnectFailedException {
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy(origin);
        return serverProxy.isPresent() ? ((ModbusServerProxy)serverProxy.get()).waitForResponses() : false;
    }

    @CheckReturnValue
    public boolean waitForResponses() throws InterruptedException, ConnectFailedException {
        Collection<PAPProxy> serverProxies = this.getKnownServerProxies();
        boolean success = true;
        for (PAPProxy serverProxy : serverProxies) {
            success &= ((ModbusServerProxy)serverProxy).waitForResponses();
        }
        return success;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> writeMultipleCoils(@Nonnull Origin serverOrigin, int startingAddress, @Nonnull short[] outputValues) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new WriteMultipleCoils.Request(startingAddress, outputValues));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> writeMultipleRegisters(@Nonnull Origin serverOrigin, int startingAddress, @Nonnull short[] registerValues) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new WriteMultipleRegisters.Request(startingAddress, registerValues));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> writePointValue(@Nonnull PointValue pointValue) throws ConnectFailedException {
        Optional register;
        Point point = (Point)pointValue.getPoint().get();
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy((Origin)point.getOrigin().get());
        Optional<Object> optional = register = serverProxy.isPresent() ? ((ModbusServerProxy)serverProxy.get()).getRegister(point) : Optional.empty();
        if (!register.isPresent()) {
            return Optional.empty();
        }
        if (((Register)register.get()).isReadOnly()) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.READ_ONLY_REGISTER, new Object[0]);
            return Optional.empty();
        }
        ((Register)register.get()).putPointValue(pointValue);
        WriteTransaction.Request request = ((Register)register.get()).createWriteRequest();
        request.setPointValue(pointValue);
        return Optional.ofNullable(((ModbusServerProxy)serverProxy.get()).sendRequest(request));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> writeReadMultipleRegisters(@Nonnull Origin serverOrigin, int writeStartingAddress, @Nonnull short[] writeRegisterValues, int readStartingAddress, int readQuantityOfregisters) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new WriteReadMultipleRegisters.Request(writeStartingAddress, writeRegisterValues, readStartingAddress, readQuantityOfregisters));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> writeSingleCoil(@Nonnull Origin serverOrigin, int outputAddress, int outputValue) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new WriteSingleCoil.Request(outputAddress, outputValue));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Request> writeSingleRegister(@Nonnull Origin serverOrigin, int registerAddress, int registerValue) throws ConnectFailedException {
        return this._sendRequest(serverOrigin, new WriteSingleRegister.Request(registerAddress, registerValue));
    }

    private Optional<Transaction.Request> _sendRequest(Origin origin, Transaction.Request request) throws ConnectFailedException {
        Optional<? extends PAPProxy> serverProxy = this.getServerProxy(origin);
        if (!serverProxy.isPresent()) {
            return Optional.empty();
        }
        ((ModbusServerProxy)serverProxy.get()).sendRequest(request);
        return Optional.of(request);
    }
}

