/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Entity;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.ModbusSupport;

public abstract class ModbusContext
extends PAPContext {
    private final Map<InetAddress, ModbusProxy> _remoteProxyByInetAddress = new HashMap<InetAddress, ModbusProxy>();
    private final Map<String, ModbusProxy> _remoteProxyBySerialPortName = new HashMap<String, ModbusProxy>();

    ModbusContext(@Nonnull Optional<Metadata> metadata, @Nonnull Optional<Traces> traces) {
        super(new ModbusSupport(), metadata, traces);
    }

    @Override
    public boolean addRemoteOrigin(Origin remoteOrigin, Attributes originAttributes) {
        boolean isFirstProxy = this.getRemoteProxyByOrigin().isEmpty();
        if (this._remoteProxyByInetAddress.isEmpty() && !isFirstProxy) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.WILDCARD_ADDRESS_RESTRICTS, new Object[0]);
            return false;
        }
        ModbusProxy remoteProxy = this.newRemoteProxy(remoteOrigin);
        if (!remoteProxy.setUp(originAttributes)) {
            return false;
        }
        if (!this._addRemoteProxyAddresses(remoteProxy, isFirstProxy, originAttributes)) {
            return false;
        }
        String serialPortName = remoteProxy.getSerialPortName();
        if (!serialPortName.isEmpty()) {
            this._remoteProxyBySerialPortName.put(serialPortName.toUpperCase(Locale.ROOT), remoteProxy);
        }
        this.registerRemoteProxy(remoteProxy);
        return true;
    }

    @Override
    public boolean addRemotePoint(Point remotePoint, Attributes pointAttributes) {
        boolean success;
        ModbusProxy remoteProxy = this.getRemoteProxy(remotePoint).orElse(null);
        if (remoteProxy == null) {
            return false;
        }
        if (pointAttributes.getBoolean("CONNECTION_STATE")) {
            return true;
        }
        Integer registerAddress = this.getRegisterAttribute(pointAttributes, "REGISTER_ADDRESS", (Entity)remotePoint).orElse(null);
        Integer coilAddress = this.getRegisterAttribute(pointAttributes, "COIL_ADDRESS", (Entity)remotePoint).orElse(null);
        Integer inputAddress = this.getRegisterAttribute(pointAttributes, "INPUT_ADDRESS", (Entity)remotePoint).orElse(null);
        Integer discreteAddress = this.getRegisterAttribute(pointAttributes, "DISCRETE_ADDRESS", (Entity)remotePoint).orElse(null);
        if (registerAddress == null && coilAddress == null && inputAddress == null && discreteAddress == null) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.NO_ADDRESS, new Object[]{remotePoint});
            return false;
        }
        Optional bit = pointAttributes.getInteger("BIT", Optional.empty());
        boolean signed = pointAttributes.getBoolean("SIGNED");
        Optional arraySize = pointAttributes.getInteger("ARRAY_SIZE", Optional.empty());
        Optional mask = pointAttributes.getInteger("MASK", Optional.empty());
        String valueType = pointAttributes.getString("TYPE").orElse(null);
        if (valueType != null) {
            valueType = valueType.toUpperCase(Locale.ROOT);
        } else if (arraySize.isPresent()) {
            valueType = "ARRAY";
        } else if (mask.isPresent()) {
            valueType = "MASK";
        } else {
            String string = valueType = bit.isPresent() || coilAddress != null || discreteAddress != null ? "BIT" : "SHORT";
        }
        if (arraySize.isPresent()) {
            if (!"ARRAY".equals(valueType)) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{"TYPE", remotePoint, valueType});
                return false;
            }
            if ((Integer)arraySize.get() < 1 || registerAddress != null && (Integer)arraySize.get() > 123 || inputAddress != null && (Integer)arraySize.get() > 125 || coilAddress != null && (Integer)arraySize.get() > 1968 || discreteAddress != null && (Integer)arraySize.get() > 2000) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{"ARRAY_SIZE", remotePoint, arraySize});
                return false;
            }
        }
        if (bit.isPresent()) {
            if (registerAddress == null && inputAddress == null) {
                this.getThisLogger().warn((Messages.Entry)ModbusMessages.NO_ADDRESS_FOR_BIT, new Object[]{remotePoint});
                return false;
            }
            if ((Integer)bit.get() < 0 || (Integer)bit.get() > 15) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{"BIT", remotePoint, bit.get()});
                return false;
            }
            if (!"BIT".equals(valueType)) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{"TYPE", remotePoint, valueType});
                return false;
            }
        } else if ("BIT".equals(valueType)) {
            if (registerAddress != null || inputAddress != null) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"BIT", "MODBUS", remotePoint});
                return false;
            }
        } else if ("MASK".equals(valueType) && registerAddress == null) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"REGISTER_ADDRESS", "MODBUS", remotePoint});
            return false;
        }
        boolean ignored = pointAttributes.getBoolean("IGNORED");
        if ("BIT".equals(valueType)) {
            success = remoteProxy.setUpBitsRegister(Optional.ofNullable(registerAddress), bit.orElse(null), remotePoint, ignored, false);
            success &= remoteProxy.setUpDiscreteRegister(Optional.ofNullable(coilAddress), remotePoint, ignored, false);
            success &= remoteProxy.setUpBitsRegister(Optional.ofNullable(inputAddress), bit.orElse(null), remotePoint, ignored, true);
            success &= remoteProxy.setUpDiscreteRegister(Optional.ofNullable(discreteAddress), remotePoint, ignored, true);
        } else if ("SHORT".equals(valueType)) {
            success = remoteProxy.setUpShortRegister(Optional.ofNullable(registerAddress), remotePoint, ignored, false, signed);
            success &= remoteProxy.setUpShortRegister(Optional.ofNullable(inputAddress), remotePoint, ignored, true, signed);
        } else if ("INTEGER".equals(valueType)) {
            success = remoteProxy.setUpIntegerRegister(Optional.ofNullable(registerAddress), remotePoint, ignored, false, signed);
            success &= remoteProxy.setUpIntegerRegister(Optional.ofNullable(inputAddress), remotePoint, ignored, true, signed);
        } else if ("FLOAT".equals(valueType)) {
            success = remoteProxy.setUpFloatRegister(Optional.ofNullable(registerAddress), remotePoint, ignored, false);
            success &= remoteProxy.setUpFloatRegister(Optional.ofNullable(inputAddress), remotePoint, ignored, true);
        } else if ("LONG".equals(valueType)) {
            success = remoteProxy.setUpLongRegister(Optional.ofNullable(registerAddress), remotePoint, ignored, false);
            success &= remoteProxy.setUpLongRegister(Optional.ofNullable(inputAddress), remotePoint, ignored, true);
        } else if ("DOUBLE".equals(valueType)) {
            success = remoteProxy.setUpDoubleRegister(Optional.ofNullable(registerAddress), remotePoint, ignored, false);
            success &= remoteProxy.setUpDoubleRegister(Optional.ofNullable(inputAddress), remotePoint, ignored, true);
        } else if ("ARRAY".equals(valueType)) {
            if (!arraySize.isPresent()) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"ARRAY_SIZE", remotePoint});
                return false;
            }
            int size = (Integer)arraySize.get();
            if (size <= 0) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{"ARRAY_SIZE", remotePoint, String.valueOf(size)});
                return false;
            }
            success = remoteProxy.setUpDiscreteArrayRegister(Optional.ofNullable(discreteAddress), size, remotePoint, ignored, true);
            success |= remoteProxy.setUpDiscreteArrayRegister(Optional.ofNullable(coilAddress), size, remotePoint, ignored, false);
            success |= remoteProxy.setUpWordArrayRegister(Optional.ofNullable(inputAddress), size, remotePoint, ignored, true);
            success |= remoteProxy.setUpWordArrayRegister(Optional.ofNullable(registerAddress), size, remotePoint, ignored, false);
        } else if ("MASK".equals(valueType)) {
            success = remoteProxy.setUpMaskedRegister(Optional.ofNullable(registerAddress), remotePoint, ignored, (Integer)mask.get());
        } else if ("STAMP".equals(valueType)) {
            success = remoteProxy.setUpStampRegister(Optional.ofNullable(registerAddress), false);
            success &= remoteProxy.setUpStampRegister(Optional.ofNullable(inputAddress), true);
        } else if ("TIME".equals(valueType)) {
            success = remoteProxy.setUpTimeRegister(Optional.ofNullable(registerAddress), false);
            success &= remoteProxy.setUpTimeRegister(Optional.ofNullable(inputAddress), true);
        } else if ("SEQUENCE".equals(valueType)) {
            success = remoteProxy.setUpSequenceRegister(Optional.ofNullable(registerAddress), false);
            success &= remoteProxy.setUpSequenceRegister(Optional.ofNullable(inputAddress), true);
        } else {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{"TYPE", remotePoint, valueType});
            return false;
        }
        if (success) {
            this.registerRemotePoint(remotePoint);
        }
        return success;
    }

    @Override
    public String getProtocolName() {
        return "Modbus";
    }

    public Collection<? extends ModbusProxy> getRemoteProxies() {
        return super.getRemoteProxies();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ModbusProxy> getRemoteProxyByInetAddress(@Nonnull InetAddress inetAddress) {
        Collection<? extends ModbusProxy> proxies;
        Object remoteProxy = this._remoteProxyByInetAddress.isEmpty() ? ((proxies = this.getRemoteProxies()).isEmpty() ? null : proxies.iterator().next()) : this._remoteProxyByInetAddress.get(inetAddress);
        return Optional.ofNullable(remoteProxy);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ModbusProxy> getRemoteProxyBySerialPortName(@Nonnull String serialPortName) {
        return Optional.ofNullable(this._remoteProxyBySerialPortName.get(serialPortName.trim().toUpperCase(Locale.ROOT)));
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<Integer> getRegisterAttribute(@Nonnull Attributes attributes, @Nonnull String key, @Nonnull Entity entity) {
        Optional attribute = attributes.getInteger(key, Optional.empty());
        if (attribute.isPresent() && ((Integer)attribute.get() < 0 || (Integer)attribute.get() > 65535)) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{key, entity, String.valueOf(attribute.get())});
        }
        return attribute;
    }

    @Override
    protected abstract ModbusProxy newRemoteProxy(Origin var1);

    private boolean _addRemoteProxyAddresses(ModbusProxy remoteProxy, boolean isFirstProxy, Attributes originAttributes) {
        String[] socketAddressStrings = originAttributes.getStrings("SOCKET_ADDRESS");
        List<InetSocketAddress> socketAddresses = remoteProxy.getSocketAddresses();
        for (String remoteProxyAddress : socketAddressStrings) {
            if (remoteProxy.supportsWildcardAddress() && "*".equals(remoteProxyAddress.trim())) {
                if (!isFirstProxy || socketAddressStrings.length > 1) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.WILDCARD_ADDRESS_RESTRICTS, new Object[0]);
                    return false;
                }
                return true;
            }
            Optional socketAddress = Inet.socketAddress((String)remoteProxyAddress);
            if (!socketAddress.isPresent()) {
                this.getThisLogger().warn((Messages.Entry)BaseMessages.BAD_ADDRESS, new Object[]{remoteProxyAddress});
                return false;
            }
            int port = ((InetSocketAddress)socketAddress.get()).getPort();
            if (port <= 0) {
                port = originAttributes.getInt("SOCKET_PORT", this.getDefaultPortForRemoteOrigin());
            }
            try {
                for (InetAddress address : InetAddress.getAllByName(((InetSocketAddress)socketAddress.get()).getHostString())) {
                    remoteProxy.addSocketAddress(new InetSocketAddress(address, port));
                }
            }
            catch (UnknownHostException exception) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN_ADDRESS, new Object[]{remoteProxy.getOrigin(), remoteProxyAddress});
                return false;
            }
        }
        for (InetSocketAddress socketAddress : socketAddresses) {
            ModbusProxy otherProxy = this._remoteProxyByInetAddress.get(socketAddress.getAddress());
            if (otherProxy != null) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.AMBIGUOUS_ORIGIN_ADDRESS, new Object[]{remoteProxy.getOrigin(), socketAddress.getAddress(), otherProxy.getOrigin()});
                return false;
            }
            this._remoteProxyByInetAddress.put(socketAddress.getAddress(), remoteProxy);
        }
        return true;
    }
}

