/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.DateTime;
import org.rvpf.base.Entity;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.modbus.ModbusContext;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.transport.Connection;

public abstract class ModbusProxy
extends PAPProxy {
    private Connection _connection;
    private boolean _littleEndian;
    private boolean _middleEndian;
    private int _sequence;
    private String _serialPortName;
    private final List<InetSocketAddress> _socketAddresses = new LinkedList<InetSocketAddress>();
    private DateTime _stamp;
    private byte _unitIdentifier;

    protected ModbusProxy(@Nonnull ModbusProxy other) {
        super(other);
        this._littleEndian = other._littleEndian;
        this._middleEndian = other._middleEndian;
        this._serialPortName = other._serialPortName;
        this._socketAddresses.addAll(other._socketAddresses);
        this._unitIdentifier = other._unitIdentifier;
    }

    protected ModbusProxy(@Nonnull ModbusContext context, @Nonnull Origin origin) {
        super(context, origin);
    }

    public final void addSocketAddress(@Nonnull InetSocketAddress socketAddress) {
        this._socketAddresses.add(socketAddress);
    }

    @Override
    public void disconnect() {
        Optional<? extends Connection> connection = this.getConnection();
        if (connection.isPresent() && !connection.get().isClosed()) {
            connection.get().stop();
        }
        super.disconnect();
    }

    public final void forgetConnection() {
        this._connection = null;
    }

    @CheckReturnValue
    public final int getSequence() {
        return this._sequence;
    }

    @Nonnull
    @CheckReturnValue
    public final String getSerialPortName() {
        return (String)Require.notNull((Object)this._serialPortName, (Object)"'setUp' has not been called");
    }

    @Nonnull
    @CheckReturnValue
    public final List<InetSocketAddress> getSocketAddresses() {
        return Collections.unmodifiableList(this._socketAddresses);
    }

    @CheckReturnValue
    public DateTime getStamp() {
        return this._stamp;
    }

    @CheckReturnValue
    public final byte getUnitIdentifier() {
        return this._unitIdentifier;
    }

    @CheckReturnValue
    public final boolean isLittleEndian() {
        return this._littleEndian;
    }

    public void setConnection(@Nonnull Connection connection) {
        this._connection = connection;
    }

    public void setSequence(int sequence) {
        this._sequence = sequence;
    }

    public void setStamp(@Nonnull Optional<DateTime> stamp) {
        this._stamp = stamp.orElse(null);
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<? extends Connection> getConnection() {
        return Optional.ofNullable(this._connection);
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<Integer> getRegisterAttribute(@Nonnull Attributes attributes, @Nonnull String key, @Nonnull Entity entity) {
        Optional attribute = attributes.getInteger(key, Optional.empty());
        if (attribute.isPresent() && ((Integer)attribute.get() < 0 || (Integer)attribute.get() > 65535)) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{key, entity, String.valueOf(attribute.get())});
            attribute = Optional.empty();
        }
        return attribute;
    }

    @CheckReturnValue
    protected final boolean isMiddleEndian() {
        return this._middleEndian;
    }

    @CheckReturnValue
    protected boolean setUp(@Nonnull Attributes originAttributes) {
        int unitIdentifier = originAttributes.getInt("UNIT_IDENTIFIER", 1);
        if (unitIdentifier < 1 || 247 < unitIdentifier) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.BAD_UNIT_IDENTIFIER, new Object[]{String.valueOf(unitIdentifier)});
            this._unitIdentifier = 1;
        } else {
            this._unitIdentifier = (byte)unitIdentifier;
        }
        this._littleEndian = originAttributes.getBoolean("LITTLE_ENDIAN");
        this._middleEndian = originAttributes.getBoolean("MIDDLE_ENDIAN");
        if (this._littleEndian) {
            this._middleEndian = !this._middleEndian;
        }
        this._serialPortName = ((String)originAttributes.getString("SERIAL_PORT", Optional.of("")).get()).trim();
        return true;
    }

    @CheckReturnValue
    abstract boolean setUpBitsRegister(@Nonnull Optional<Integer> var1, @Nonnull Integer var2, @Nonnull Point var3, boolean var4, boolean var5);

    @CheckReturnValue
    abstract boolean setUpDiscreteArrayRegister(@Nonnull Optional<Integer> var1, int var2, @Nonnull Point var3, boolean var4, boolean var5);

    @CheckReturnValue
    abstract boolean setUpDiscreteRegister(@Nonnull Optional<Integer> var1, @Nonnull Point var2, boolean var3, boolean var4);

    @CheckReturnValue
    abstract boolean setUpDoubleRegister(@Nonnull Optional<Integer> var1, @Nonnull Point var2, boolean var3, boolean var4);

    @CheckReturnValue
    abstract boolean setUpFloatRegister(@Nonnull Optional<Integer> var1, @Nonnull Point var2, boolean var3, boolean var4);

    @CheckReturnValue
    abstract boolean setUpIntegerRegister(@Nonnull Optional<Integer> var1, @Nonnull Point var2, boolean var3, boolean var4, boolean var5);

    @CheckReturnValue
    abstract boolean setUpLongRegister(@Nonnull Optional<Integer> var1, @Nonnull Point var2, boolean var3, boolean var4);

    @CheckReturnValue
    abstract boolean setUpMaskedRegister(@Nonnull Optional<Integer> var1, @Nonnull Point var2, boolean var3, int var4);

    @CheckReturnValue
    abstract boolean setUpSequenceRegister(@Nonnull Optional<Integer> var1, boolean var2);

    @CheckReturnValue
    abstract boolean setUpShortRegister(@Nonnull Optional<Integer> var1, @Nonnull Point var2, boolean var3, boolean var4, boolean var5);

    @CheckReturnValue
    abstract boolean setUpStampRegister(@Nonnull Optional<Integer> var1, boolean var2);

    @CheckReturnValue
    abstract boolean setUpTimeRegister(@Nonnull Optional<Integer> var1, boolean var2);

    @CheckReturnValue
    abstract boolean setUpWordArrayRegister(@Nonnull Optional<Integer> var1, int var2, @Nonnull Point var3, boolean var4, boolean var5);
}

