/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.modbus.ModbusClientProxy;
import org.rvpf.pap.modbus.ModbusContext;

public final class ModbusServerContext
extends ModbusContext {
    private final Map<String, Origin> _origins = new HashMap<String, Origin>();

    ModbusServerContext(@Nonnull Optional<Metadata> metadata, @Nonnull String[] originNames, @Nonnull Optional<Traces> traces) {
        super(metadata, traces);
        for (String originName : originNames) {
            this._origins.put(originName.toUpperCase(Locale.ROOT), null);
        }
    }

    @Override
    public boolean isClientContext() {
        return false;
    }

    @Override
    protected boolean isRemoteOriginNeeded(Origin origin, Attributes originAttributes) {
        String originName = (String)origin.getNameInUpperCase().get();
        if (this._origins.isEmpty() || this._origins.containsKey(originName)) {
            return this._origins.put(originName, origin) == null;
        }
        return false;
    }

    @Override
    protected boolean isRemotePointNeeded(Point point, Attributes pointAttributes) {
        Optional origin = point.getOrigin();
        if (!origin.isPresent() || !point.getAttributes("MODBUS").isPresent()) {
            return false;
        }
        return this._origins.get(((Origin)origin.get()).getNameInUpperCase().get()) != null;
    }

    @Override
    protected ModbusClientProxy newRemoteProxy(Origin origin) {
        return new ModbusClientProxy(this, origin);
    }
}

