/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.SerialPortWrapper;
import org.rvpf.pap.modbus.Modbus;
import org.rvpf.pap.modbus.ModbusContext;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.register.ArrayRegister;
import org.rvpf.pap.modbus.register.DiscreteArrayRegister;
import org.rvpf.pap.modbus.register.DiscreteRegister;
import org.rvpf.pap.modbus.register.DoubleRegister;
import org.rvpf.pap.modbus.register.FloatRegister;
import org.rvpf.pap.modbus.register.IntegerRegister;
import org.rvpf.pap.modbus.register.LongRegister;
import org.rvpf.pap.modbus.register.MaskedRegister;
import org.rvpf.pap.modbus.register.Register;
import org.rvpf.pap.modbus.register.SequenceRegister;
import org.rvpf.pap.modbus.register.ShortRegister;
import org.rvpf.pap.modbus.register.StampRegister;
import org.rvpf.pap.modbus.register.TimeRegister;
import org.rvpf.pap.modbus.register.WordArrayRegister;
import org.rvpf.pap.modbus.transport.ClientConnection;
import org.rvpf.pap.modbus.transport.Connection;
import org.rvpf.pap.modbus.transport.Transport;

public final class ModbusServerProxy
extends ModbusProxy
implements SerialPortWrapper.StatusChangeListener {
    private int _batchSize;
    private ElapsedTime _connectTimeout;
    private final Object _mutex = new Object();
    private final Map<Point, Register> _registersByPoint = new HashMap<Point, Register>();
    private int _requestRetries;
    private ElapsedTime _requestRetryInterval;
    private ElapsedTime _requestTimeout;
    private final Map<Transaction.Request, Transaction.Response> _requests = new ConcurrentHashMap<Transaction.Request, Transaction.Response>();
    private SerialPortWrapper _serialPort;
    private int _serialPortMode;
    private final Traces _traces;

    ModbusServerProxy(@Nonnull ModbusContext context, @Nonnull Origin origin, @Nonnull Traces traces) {
        super(context, origin);
        this._traces = traces;
    }

    private ModbusServerProxy(ModbusServerProxy other) {
        super(other);
        this._batchSize = other._batchSize;
        this._connectTimeout = other._connectTimeout;
        this._registersByPoint.putAll(other._registersByPoint);
        this._requestRetries = other._requestRetries;
        this._requestRetryInterval = other._requestRetryInterval;
        this._requestTimeout = other._requestTimeout;
        this._serialPort = other._serialPort;
        this._serialPortMode = other._serialPortMode;
        this._traces = other._traces;
    }

    @Nonnull
    @CheckReturnValue
    public Collection<Transaction.Request> clearCompletedRequests() {
        LinkedList<Transaction.Request> completedRequests = new LinkedList<Transaction.Request>();
        Iterator<Map.Entry<Transaction.Request, Transaction.Response>> iterator = this._requests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Transaction.Request, Transaction.Response> entry = iterator.next();
            if (entry.getValue() == Transaction.Response.NULL) continue;
            completedRequests.add(entry.getKey());
            iterator.remove();
        }
        return completedRequests;
    }

    @Override
    public PAPProxy copy() {
        return new ModbusServerProxy(this);
    }

    @CheckReturnValue
    public int getBatchSize() {
        return this._batchSize;
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime getConnectTimeout() {
        return (ElapsedTime)Require.notNull((Object)this._connectTimeout);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Register> getRegister(@Nonnull Point point) {
        return Optional.ofNullable(this._registersByPoint.get(Require.notNull((Object)point)));
    }

    @CheckReturnValue
    public int getRequestRetries() {
        return this._requestRetries;
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime getRequestTimeout() {
        return (ElapsedTime)Require.notNull((Object)this._requestTimeout);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Transaction.Response> getResponse(@Nonnull Transaction.Request request) throws InterruptedException, ConnectFailedException {
        Transaction.Response response = this.waitForResponse(request) ? this._requests.remove(request) : null;
        Require.success((response != Transaction.Response.NULL ? 1 : 0) != 0);
        request.setState(Transaction.State.INACTIVE);
        return Optional.ofNullable(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    @CheckReturnValue
    public Optional<SerialPortWrapper> getSerialPort() {
        if (this._serialPort == null) return Optional.ofNullable(this._serialPort);
        if (!this._serialPort.isClosed()) return Optional.ofNullable(this._serialPort);
        try {
            this._serialPort.open();
            if (this._serialPort.isPortModem()) {
                long timeout = this._connectTimeout.toMillis();
                long startMillis = System.currentTimeMillis();
                Object object = this._mutex;
                synchronized (object) {
                    this._serialPort.addStatusChangeListener(this);
                    try {
                        while (this._serialPort.isOpen() && !this._serialPort.getDSR() && timeout != 0L) {
                            long elapsed = System.currentTimeMillis() - startMillis;
                            if (elapsed < 0L) {
                                startMillis = System.currentTimeMillis();
                                continue;
                            }
                            long wait = timeout - elapsed;
                            if (wait <= 0L) break;
                            try {
                                this._mutex.wait(wait);
                            }
                            catch (InterruptedException exception) {
                                throw (IOException)new InterruptedIOException().initCause(exception);
                            }
                        }
                        if (this._serialPort.isClosed()) {
                            Optional<SerialPortWrapper> optional = Optional.empty();
                            return optional;
                        }
                    }
                    finally {
                        this._serialPort.removeStatusChangeListener(this);
                    }
                    if (!this._serialPort.getDSR()) {
                        this._serialPort.close();
                        return Optional.empty();
                    }
                }
            }
            this._serialPort.purge();
            return Optional.ofNullable(this._serialPort);
        }
        catch (IOException exception1) {
            try {
                this._serialPort.close();
                return Optional.empty();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusChange(SerialPortWrapper serialPort, SerialPortWrapper.Event event) {
        Object object = this._mutex;
        synchronized (object) {
            Require.equal((Object)this._serialPort, (Object)serialPort);
            switch (event) {
                case CLOSED: 
                case DSR_ON: {
                    this._mutex.notifyAll();
                    break;
                }
            }
        }
    }

    public void putResponse(@Nonnull Transaction.Response response) {
        Transaction.Request request = response.getRequest();
        boolean wasPending = this._requests.put(request, response) == Transaction.Response.NULL;
        Require.success((boolean)wasPending);
        request.setState(Transaction.State.ANSWERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public boolean waitForResponse(@Nonnull Transaction.Request request) throws InterruptedException, ConnectFailedException {
        block7: {
            if (request.getState() == Transaction.State.INACTIVE) {
                return true;
            }
            while (true) {
                Transaction.Request request2 = request;
                synchronized (request2) {
                    while (!request.hasBeenAnswered() && !request.hasFailed()) {
                        request.wait();
                    }
                }
                if (!request.hasFailed()) break block7;
                if (!request.updateRetries()) break;
                long retryIntervalMillis = this._requestRetryInterval.toMillis();
                if (retryIntervalMillis > 0L) {
                    Thread.sleep(retryIntervalMillis);
                }
                request.setState(Transaction.State.ACTIVE);
                this._doSendRequest(request);
            }
            return false;
        }
        return true;
    }

    @CheckReturnValue
    public boolean waitForResponses() throws InterruptedException, ConnectFailedException {
        boolean success = true;
        try {
            for (Transaction.Request request : this._requests.keySet()) {
                success &= this.waitForResponse(request);
            }
        }
        catch (ConnectFailedException exception) {
            this._requests.clear();
            throw exception;
        }
        return success;
    }

    @Override
    protected boolean setUp(Attributes originAttributes) {
        int batchSize;
        if (!super.setUp(originAttributes)) {
            return false;
        }
        String serialPortName = this.getSerialPortName();
        if (!serialPortName.isEmpty()) {
            this._serialPortMode = Transport.serialMode(originAttributes.getString("SERIAL_MODE").orElse(null));
            this._serialPort = SerialPortWrapper.newBuilder().setPortName(serialPortName).setPortSpeed(originAttributes.getInt("SERIAL_SPEED", 9600)).setPortDataBits(Transport.serialModeDataBits(this._serialPortMode)).setPortParity((String)originAttributes.getString("SERIAL_PARITY", Optional.of("EVEN")).get()).setPortModem(originAttributes.getBoolean("SERIAL_MODEM", false)).setPortControl(originAttributes.getBoolean("SERIAL_CONTROL", false)).build();
        }
        this._batchSize = (batchSize = originAttributes.getInt("BATCH_SIZE", 1)) <= 0 ? Integer.MAX_VALUE : batchSize;
        this.getThisLogger().debug((Messages.Entry)ModbusMessages.BATCH_SIZE, new Object[]{String.valueOf(this._batchSize)});
        this._connectTimeout = (ElapsedTime)originAttributes.getElapsed("CONNECT_TIMEOUT", Optional.of(Modbus.DEFAULT_CONNECT_TIMEOUT), Optional.of(ElapsedTime.INFINITY)).get();
        this.getThisLogger().debug((Messages.Entry)ModbusMessages.CONNECT_TIMEOUT, new Object[]{this._connectTimeout});
        if (this._connectTimeout.toMillis() > Integer.MAX_VALUE) {
            this._connectTimeout = ElapsedTime.fromMillis((long)Integer.MAX_VALUE);
        }
        this._requestTimeout = (ElapsedTime)originAttributes.getElapsed("REQUEST_TIMEOUT", Optional.of(Modbus.DEFAULT_REQUEST_TIMEOUT), Optional.of(ElapsedTime.INFINITY)).get();
        this.getThisLogger().debug((Messages.Entry)ModbusMessages.REQUEST_TIMEOUT, new Object[]{this._requestTimeout});
        this._requestRetries = originAttributes.getInt("REQUEST_RETRIES", 0);
        if (this._requestRetries > 0) {
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.REQUEST_RETRIES, new Object[]{String.valueOf(this._requestRetries)});
            this._requestRetryInterval = (ElapsedTime)originAttributes.getElapsed("REQUEST_RETRY_INTERVAL", Optional.of(Modbus.DEFAULT_REQUEST_RETRY_INTERVAL), Optional.of(ElapsedTime.EMPTY)).get();
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.REQUEST_RETRY_INTERVAL, new Object[]{this._requestRetryInterval});
        }
        return true;
    }

    @Nonnull
    @CheckReturnValue
    Optional<? extends Connection> connect(boolean log) {
        Optional<SerialPortWrapper> serialPort;
        Optional<? extends Connection> connection = this.getConnection();
        if (connection.isPresent()) {
            if (!connection.get().isClosed()) {
                return connection;
            }
            connection.get().stop();
            this.forgetConnection();
            connection = null;
        }
        ElapsedTime connectTimeout = this.getConnectTimeout();
        boolean onSerialPort = false;
        Transport transport = null;
        int transports = 0;
        for (InetSocketAddress socketAddress : this.getSocketAddresses()) {
            ++transports;
            if (log) {
                this.getThisLogger().debug((Messages.Entry)ModbusMessages.TRYING_SERVER_CONNECTION, new Object[]{socketAddress});
            }
            Socket socket = new Socket();
            try {
                socket.connect(socketAddress, (int)connectTimeout.toMillis());
            }
            catch (IOException exception1) {
                if (log) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.SERVER_CONNECTION_FAILED, new Object[]{socketAddress});
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            transport = Transport.newSocketTransport(socket, this.getUnitIdentifier(), this._traces);
            break;
        }
        if (transport == null && (serialPort = this.getSerialPort()).isPresent()) {
            ++transports;
            transport = Transport.newSerialPortTransport(serialPort.get(), this._serialPortMode, this.getUnitIdentifier(), this._traces);
            onSerialPort = true;
        }
        if (transport != null) {
            if (log) {
                this.getThisLogger().debug((Messages.Entry)ModbusMessages.SERVER_CONNECTION_SUCCEEDED, new Object[]{transport.getRemoteAddress(), String.valueOf(this.getUnitIdentifier() & 0xFF)});
                if (onSerialPort) {
                    this.getThisLogger().debug((Messages.Entry)ModbusMessages.SERIAL_MODE, new Object[]{transport.getRemoteAddress(), Transport.serialModeName(this._serialPortMode)});
                }
            }
            connection = Optional.of(new ClientConnection(transport, this, this.getConnectionListener()));
            this.setConnection(connection.get());
            connection.get().start();
        } else if (log && transports != 1) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.SERVER_CONNECTIONS_FAILED, new Object[]{this.getOrigin()});
        }
        return connection;
    }

    @Nonnull
    Transaction.Request sendRequest(@Nonnull Transaction.Request request) throws ConnectFailedException {
        request.setServerProxy(this);
        request.setState(Transaction.State.ACTIVE);
        this._requests.put(request, Transaction.Response.NULL);
        this._doSendRequest(request);
        return request;
    }

    @Override
    boolean setUpBitsRegister(Optional<Integer> address, Integer bit, Point point, boolean ignored, boolean readOnly) {
        return true;
    }

    @Override
    boolean setUpDiscreteArrayRegister(Optional<Integer> address, int size, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._setUpArrayRegister(new DiscreteArrayRegister(address, size, Optional.of(point), readOnly));
    }

    @Override
    boolean setUpDiscreteRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._addRegister(new DiscreteRegister(address, Optional.of(point), readOnly));
    }

    @Override
    boolean setUpDoubleRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._addRegister(new DoubleRegister(address, Optional.of(point), readOnly, this.isMiddleEndian()));
    }

    @Override
    boolean setUpFloatRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._addRegister(new FloatRegister(address, Optional.of(point), readOnly, this.isMiddleEndian()));
    }

    @Override
    boolean setUpIntegerRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly, boolean signed) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._addRegister(new IntegerRegister(address, Optional.of(point), signed, readOnly, this.isMiddleEndian()));
    }

    @Override
    boolean setUpLongRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._addRegister(new LongRegister(address, Optional.of(point), readOnly, this.isMiddleEndian()));
    }

    @Override
    boolean setUpMaskedRegister(Optional<Integer> address, Point point, boolean ignored, int mask) {
        if (!address.isPresent()) {
            return true;
        }
        return this._addRegister(new MaskedRegister(address, ignored ? Optional.empty() : Optional.of(point), mask));
    }

    @Override
    boolean setUpSequenceRegister(Optional<Integer> address, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        return this._addRegister(new SequenceRegister(address, Optional.empty(), readOnly));
    }

    @Override
    boolean setUpShortRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly, boolean signed) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._addRegister(new ShortRegister(address, Optional.of(point), signed, readOnly));
    }

    @Override
    boolean setUpStampRegister(Optional<Integer> address, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        return this._addRegister(new StampRegister(address, Optional.empty(), readOnly, this.isMiddleEndian()));
    }

    @Override
    boolean setUpTimeRegister(Optional<Integer> address, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        return this._addRegister(new TimeRegister(address, Optional.empty(), readOnly, this.isMiddleEndian()));
    }

    @Override
    boolean setUpWordArrayRegister(Optional<Integer> address, int size, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent() || ignored) {
            return true;
        }
        return this._setUpArrayRegister(new WordArrayRegister(address, size, Optional.of(point), readOnly));
    }

    private boolean _addRegister(Register register) {
        Point point;
        Integer address = register.getAddress().get();
        if (address < 1 || 65536 < address) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.INVALID_ADDRESS, new Object[]{address, Arrays.toString(register.getPoints())});
            return false;
        }
        Point[] registerPoints = register.getPoints();
        if (registerPoints.length > 0 && !this._registersByPoint.containsKey(point = registerPoints[0])) {
            this._registersByPoint.put(registerPoints[0], register);
        }
        return true;
    }

    private void _doSendRequest(Transaction.Request request) throws ConnectFailedException {
        Optional<? extends Connection> connection = this.connect(request.getRetries() == 0);
        if (!connection.isPresent()) {
            request.setState(Transaction.State.FAILED);
            throw new ConnectFailedException();
        }
        ((ClientConnection)connection.get()).sendRequest(request);
    }

    private boolean _setUpArrayRegister(ArrayRegister arrayRegister) {
        if (!this._addRegister(arrayRegister)) {
            return false;
        }
        for (int i = 1; i < arrayRegister.size(); ++i) {
            if (this._addRegister(arrayRegister.newMinion(i))) continue;
            return false;
        }
        return true;
    }
}

