/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.transport.ExceptionCode;
import org.rvpf.pap.modbus.transport.Transport;

public final class ErrorResponse
extends Transaction.Response {
    private final byte _errorCode;
    private byte _exceptionCode;

    public ErrorResponse(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
        super(prefix, request);
        this._errorCode = request.getFunctionCode();
    }

    public ErrorResponse(@Nonnull Prefix prefix, byte functionCode, @Nonnull ExceptionCode exceptionCode) {
        super(prefix, Transaction.Request.NULL);
        this._errorCode = functionCode;
        this._exceptionCode = exceptionCode.getCodeByte();
    }

    ErrorResponse(@Nonnull Transaction.Request request) {
        super(request);
        this._errorCode = request.getFunctionCode();
        this._exceptionCode = request.getExceptionCode();
    }

    @CheckReturnValue
    public byte getErrorCode() {
        return this._errorCode;
    }

    @CheckReturnValue
    public byte getExceptionCode() {
        return this._exceptionCode;
    }

    @Nonnull
    @CheckReturnValue
    public String getExceptionCodeName() {
        return ExceptionCode.getInstance(this._exceptionCode).getName();
    }

    @Override
    public byte getFunctionCode() {
        return (byte)(this._errorCode | 0x80);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public void read(Transport transport) throws IOException, Transaction.FormatException {
        this.expectedBytes(1);
        this._exceptionCode = transport.receiveByte();
        ErrorResponse.readSuffix(transport);
    }

    @Override
    public void write(Transport transport) throws IOException {
        super.write(this.getLength(), transport);
        transport.sendByte(this._exceptionCode);
        ErrorResponse.writeSuffix(transport);
    }
}

