/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.transport.Transport;

public interface MaskWriteRegister {
    public static final short FUNCTION_CODE = 22;

    public static final class Response
    extends WriteTransaction.Response {
        public Response(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
            super(prefix, (WriteTransaction.Request)request);
        }

        Response(Request request) {
            super(request);
        }

        @Override
        public int getLength() {
            return 6;
        }

        @Override
        public void read(Transport transport) throws IOException, Transaction.FormatException {
            int address = (transport.receiveShort() & 0xFFFF) + 1;
            int andMask = transport.receiveShort() & 0xFFFF;
            int orMask = transport.receiveShort() & 0xFFFF;
            Request request = (Request)this.getRequest();
            if (address != request.getAddress()) {
                throw new Transaction.FormatException(ModbusMessages.REGISTER_ADDRESS_MATCH, new Object[0]);
            }
            if (andMask != request.getAndMask()) {
                throw new Transaction.FormatException(ModbusMessages.REGISTER_AND_MASK_MATCH, new Object[0]);
            }
            if (orMask != request.getOrMask()) {
                throw new Transaction.FormatException(ModbusMessages.REGISTER_OR_MASK_MATCH, new Object[0]);
            }
            Response.readSuffix(transport);
        }

        @Override
        public void write(Transport transport) throws IOException {
            super.write(this.getLength(), transport);
            Request request = (Request)this.getRequest();
            transport.sendShort(request.getAddress() - 1);
            transport.sendShort(request.getAndMask());
            transport.sendShort(request.getOrMask());
            Response.writeSuffix(transport);
        }
    }

    public static final class Request
    extends WriteTransaction.Request {
        private int _andMask;
        private int _orMask;

        public Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public Request(int registerAddress, int andMask, int orMask) {
            this.setAddress(registerAddress);
            this._andMask = andMask & 0xFFFF;
            this._orMask = orMask & 0xFFFF;
        }

        public void applyMasks(int value) {
            value &= this._andMask;
            this.setValue(value |= this._orMask & ~this._andMask);
        }

        @Override
        public Transaction.Response createResponse(short[] values) {
            Require.equal((long)0L, (long)values.length);
            return this.isValid() ? new Response(this) : this.errorResponse();
        }

        @Override
        public byte getFunctionCode() {
            return 22;
        }

        @Override
        public int getLength() {
            return 6;
        }

        @Override
        public int getReadAddress() {
            return this.getAddress();
        }

        @Override
        public int getReadQuantity() {
            return 1;
        }

        @Override
        public Request read(Transport transport) throws IOException, Transaction.FormatException {
            this.setAddress(transport.receiveShort() + 1);
            this._andMask = transport.receiveShort() & 0xFFFF;
            this._orMask = transport.receiveShort() & 0xFFFF;
            Request.readSuffix(transport);
            return this;
        }

        @Override
        public void write(Transport transport) throws IOException {
            this.write(this.getLength(), transport);
            transport.sendShort(this.getAddress() - 1);
            transport.sendShort(this._andMask);
            transport.sendShort(this._orMask);
            Request.writeSuffix(transport);
        }

        @CheckReturnValue
        int getAndMask() {
            return this._andMask;
        }

        @CheckReturnValue
        int getOrMask() {
            return this._orMask;
        }
    }
}

