/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.pap.modbus.transport.Transport;

@NotThreadSafe
public class Prefix {
    private byte _unitIdentifier;

    public Prefix(byte unitIdentifier) {
        this._unitIdentifier = unitIdentifier;
    }

    protected Prefix(@Nonnull Prefix other) {
        this._unitIdentifier = other._unitIdentifier;
    }

    @CheckReturnValue
    public boolean checkDataLength(int expectedDataLength) {
        return true;
    }

    @Nonnull
    @CheckReturnValue
    public Prefix copy() {
        return new Prefix(this);
    }

    @CheckReturnValue
    public byte getUnitIdentifier() {
        return this._unitIdentifier;
    }

    public void saveDataLength(int dataLength) {
    }

    public void write(@Nonnull Transport transport) throws IOException {
        transport.sendByte(this._unitIdentifier);
    }

    public static final class MBAP
    extends Prefix {
        private int _dataLength;
        private short _transaction;

        public MBAP(short transaction, byte unitIdentifier) {
            super(unitIdentifier);
            this._transaction = transaction;
        }

        private MBAP(MBAP other) {
            super(other);
            this._dataLength = other._dataLength;
        }

        @Nonnull
        @CheckReturnValue
        public static MBAP read(@Nonnull Transport transport) throws EOFException, IOException {
            short transaction = transport.receiveShort();
            if (transport.receiveShort() != 0) {
                throw new ProtocolException();
            }
            short dataLength = (short)(transport.receiveShort() - 2);
            if ((dataLength & 0xFF00) != 0) {
                throw new ProtocolException();
            }
            MBAP mbap = new MBAP(transaction, transport.receiveByte());
            mbap.saveDataLength(dataLength);
            return mbap;
        }

        @Override
        public boolean checkDataLength(int expectedDataLength) {
            return this._dataLength == expectedDataLength;
        }

        @Override
        public MBAP copy() {
            return new MBAP(this);
        }

        @CheckReturnValue
        public short getTransaction() {
            return this._transaction;
        }

        @Override
        public void saveDataLength(int dataLength) {
            this._dataLength = dataLength;
        }

        @Override
        public void write(Transport transport) throws IOException {
            transport.sendShort(this._transaction);
            transport.sendShort(0);
            transport.sendShort(2 + this._dataLength);
            transport.sendByte(this.getUnitIdentifier());
        }
    }
}

