/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.transport.Transport;

public interface ReadDiscreteInputs {
    public static final short FUNCTION_CODE = 2;
    public static final short MAXIMUM_QUANTITY = 2000;

    public static final class Response
    extends ReadTransaction.Response {
        public Response(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
            super(prefix, (ReadTransaction.Request)request);
        }

        Response(@Nonnull Request request) {
            super(request);
        }

        @Override
        public int getLength() {
            return 1 + Response._byteCount(this.getValues().length);
        }

        @Override
        public void read(Transport transport) throws IOException, Transaction.FormatException {
            int quantity = this.getRequest().getQuantity();
            int byteCount = transport.receiveByte() & 0xFF;
            if (byteCount != Response._byteCount(quantity)) {
                throw new Transaction.FormatException(ModbusMessages.BYTE_COUNT_INPUTS, byteCount, quantity);
            }
            this.expectedBytes(1 + byteCount);
            short[] values = new short[quantity];
            int index = 0;
            block0: for (int i = 0; i < byteCount; ++i) {
                byte value = transport.receiveByte();
                int shift = Math.min(8, quantity - index);
                --shift;
                while (shift >= 0) {
                    values[index] = (short)(value >> shift & 1);
                    if (++index >= quantity) continue block0;
                    --shift;
                }
            }
            this.setValues(values);
            Response.readSuffix(transport);
        }

        @Override
        public void write(Transport transport) throws IOException {
            short[] values = this.getValues();
            short quantity = (short)values.length;
            int byteCount = Response._byteCount(quantity);
            this.write(1 + byteCount, transport);
            transport.sendByte(byteCount);
            int index = 0;
            for (int i = 0; i < byteCount; ++i) {
                int shift = Math.min(8, quantity - index);
                int valueByte = 0;
                --shift;
                while (shift >= 0) {
                    int value = values[index] != 0 ? 1 : 0;
                    valueByte = (byte)(valueByte | value << shift);
                    if (++index >= quantity) break;
                    --shift;
                }
                transport.sendByte(valueByte);
            }
            Response.writeSuffix(transport);
        }

        private static int _byteCount(int quantity) {
            int byteCount = quantity / 8;
            if (quantity % 8 != 0) {
                ++byteCount;
            }
            return byteCount;
        }
    }

    public static final class Request
    extends ReadTransaction.Request {
        public Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public Request(int startingAddress, int quantity) {
            if (quantity < 1 || 2000 < quantity) {
                throw new IllegalArgumentException();
            }
            this.setAddress(startingAddress);
            this.setQuantity(quantity);
        }

        @Override
        public Transaction.Response createResponse(@Nonnull short[] values) {
            return this.initResponse(new Response(this), values);
        }

        @Override
        public byte getFunctionCode() {
            return 2;
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public Request read(Transport transport) throws IOException, Transaction.FormatException {
            this.expectedBytes(4);
            this.setAddress(transport.receiveShort() + 1);
            this.setQuantity(transport.receiveShort());
            Request.readSuffix(transport);
            return this;
        }

        @Override
        public void write(Transport transport) throws IOException {
            this.write(this.getLength(), transport);
            transport.sendShort(this.getAddress() - 1);
            transport.sendShort(this.getQuantity());
            Request.writeSuffix(transport);
        }
    }
}

