/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.transport.Transport;

public interface ReadInputRegisters {
    public static final short FUNCTION_CODE = 4;
    public static final short MAXIMUM_QUANTITY = 125;

    public static final class Response
    extends ReadTransaction.Response {
        public Response(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
            super(prefix, (ReadTransaction.Request)request);
        }

        Response(@Nonnull Request request) {
            super(request);
        }

        @Override
        public int getLength() {
            return 1 + this.getValues().length * 2;
        }

        @Override
        public void read(Transport transport) throws IOException, Transaction.FormatException {
            int quantity = this.getRequest().getQuantity();
            int byteCount = transport.receiveByte() & 0xFF;
            if (byteCount != quantity * 2) {
                throw new Transaction.FormatException(ModbusMessages.BYTE_COUNT_REGISTERS, byteCount, quantity);
            }
            this.expectedBytes(1 + byteCount);
            short[] values = new short[quantity];
            for (int i = 0; i < quantity; ++i) {
                values[i] = transport.receiveShort();
            }
            this.setValues(values);
            Response.readSuffix(transport);
        }

        @Override
        public void write(Transport transport) throws IOException {
            short[] values = this.getValues();
            this.write(1 + values.length * 2, transport);
            transport.sendByte(values.length * 2);
            for (short value : values) {
                transport.sendShort(value);
            }
            Response.writeSuffix(transport);
        }
    }

    public static final class Request
    extends ReadTransaction.Request {
        public Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public Request(int startingAddress, int quantity) {
            if (quantity < 1 || 125 < quantity) {
                throw new IllegalArgumentException();
            }
            this.setAddress(startingAddress);
            this.setQuantity(quantity);
        }

        @Override
        public Transaction.Response createResponse(@Nonnull short[] values) {
            return this.initResponse(new Response(this), values);
        }

        @Override
        public byte getFunctionCode() {
            return 4;
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public Request read(Transport transport) throws IOException, Transaction.FormatException {
            this.expectedBytes(4);
            this.setAddress(transport.receiveShort() + 1);
            this.setQuantity(transport.receiveShort());
            Request.readSuffix(transport);
            return this;
        }

        @Override
        public void write(Transport transport) throws IOException {
            this.write(this.getLength(), transport);
            transport.sendShort(this.getAddress() - 1);
            transport.sendShort(this.getQuantity());
            Request.writeSuffix(transport);
        }
    }
}

